/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;

public class ByteBufferEntity
extends AbstractHttpEntity {
    private final ByteBuffer buffer;

    public ByteBufferEntity(ByteBuffer buffer, ContentType contentType) {
        Args.notNull(buffer, "Source byte buffer");
        this.buffer = buffer;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public ByteBufferEntity(ByteBuffer buffer) {
        this(buffer, null);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.buffer.capacity();
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return new ByteBufferInputStream();
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        WritableByteChannel channel = Channels.newChannel(outStream);
        channel.write(this.buffer);
        outStream.flush();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    private class ByteBufferInputStream
    extends InputStream {
        ByteBufferInputStream() {
            ByteBufferEntity.this.buffer.position(0);
        }

        @Override
        public int read() throws IOException {
            if (!ByteBufferEntity.this.buffer.hasRemaining()) {
                return -1;
            }
            return ByteBufferEntity.this.buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!ByteBufferEntity.this.buffer.hasRemaining()) {
                return -1;
            }
            int chunk = Math.min(len, ByteBufferEntity.this.buffer.remaining());
            ByteBufferEntity.this.buffer.get(bytes, off, chunk);
            return chunk;
        }
    }
}

