/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Internal
public class Http2OnlyClientProtocolNegotiator
implements HttpConnectionEventHandler {
    private final ProtocolIOSession ioSession;
    private final ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final boolean strictALPNHandshake;
    private final ByteBuffer preface;

    public Http2OnlyClientProtocolNegotiator(ProtocolIOSession ioSession, ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory, boolean strictALPNHandshake) {
        this.ioSession = (ProtocolIOSession)Args.notNull((Object)ioSession, (String)"I/O session");
        this.http2StreamHandlerFactory = (ClientHttp2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
        this.strictALPNHandshake = strictALPNHandshake;
        this.preface = ByteBuffer.wrap(ClientHttpProtocolNegotiator.PREFACE);
    }

    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            if (tlsDetails != null) {
                String applicationProtocol = tlsDetails.getApplicationProtocol();
                if (TextUtils.isEmpty((CharSequence)applicationProtocol)) {
                    if (this.strictALPNHandshake) {
                        throw new HttpException("ALPN: missing application protocol");
                    }
                } else if (!ApplicationProtocols.HTTP_2.id.equals(applicationProtocol)) {
                    throw new HttpException("ALPN: unexpected application protocol '" + applicationProtocol + "'");
                }
            }
            this.writePreface(session);
        }
        catch (Exception ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    private void writePreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            ByteChannel channel = session.channel();
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            ClientHttp2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
            ClientHttp2IOEventHandler newHandler = new ClientHttp2IOEventHandler(streamMultiplexer);
            newHandler.connected(session);
            this.ioSession.upgrade((IOEventHandler)newHandler);
        }
    }

    public void inputReady(IOSession session) {
        this.outputReady(session);
    }

    public void outputReady(IOSession session) {
        try {
            if (this.preface != null) {
                this.writePreface(session);
            } else {
                session.close(CloseMode.IMMEDIATE);
            }
        }
        catch (IOException ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    public void timeout(IOSession session, int timeoutMillis) {
        this.exception(session, SocketTimeoutExceptionFactory.create((int)timeoutMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(IOSession session, Exception cause) {
        try {
            Command command;
            while ((command = this.ioSession.poll()) != null) {
                if (command instanceof RequestExecutionCommand) {
                    RequestExecutionCommand executionCommand = (RequestExecutionCommand)command;
                    AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                    exchangeHandler.failed(cause);
                    exchangeHandler.releaseResources();
                    continue;
                }
                command.cancel();
            }
        }
        finally {
            session.close(CloseMode.IMMEDIATE);
        }
    }

    public void disconnected(IOSession session) {
        Command command;
        while ((command = this.ioSession.poll()) != null) {
            if (command instanceof RequestExecutionCommand) {
                RequestExecutionCommand executionCommand = (RequestExecutionCommand)command;
                AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                exchangeHandler.failed((Exception)new ConnectionClosedException());
                exchangeHandler.releaseResources();
                continue;
            }
            command.cancel();
        }
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        return null;
    }

    public void setSocketTimeoutMillis(int timeout) {
        this.ioSession.setSocketTimeoutMillis(timeout);
    }

    public int getSocketTimeoutMillis() {
        return this.ioSession.getSocketTimeoutMillis();
    }

    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    public void close() throws IOException {
        this.ioSession.close();
    }

    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

