/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http2.impl.nio.AbstractHttp2StreamMultiplexer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

class AbstractHttp2IOEventHandler
implements HttpConnectionEventHandler {
    private final AbstractHttp2StreamMultiplexer streamMultiplexer;

    AbstractHttp2IOEventHandler(AbstractHttp2StreamMultiplexer streamMultiplexer) {
        this.streamMultiplexer = (AbstractHttp2StreamMultiplexer)Args.notNull((Object)streamMultiplexer, (String)"Stream multiplexer");
    }

    public void connected(IOSession session) throws IOException {
        try {
            this.streamMultiplexer.onConnect(null);
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException((Exception)((Object)ex));
        }
    }

    public void inputReady(IOSession session) throws IOException {
        try {
            this.streamMultiplexer.onInput();
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException((Exception)((Object)ex));
        }
    }

    public void outputReady(IOSession session) throws IOException {
        try {
            this.streamMultiplexer.onOutput();
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException((Exception)((Object)ex));
        }
    }

    public void timeout(IOSession session, int timeoutMillis) throws IOException {
        try {
            this.streamMultiplexer.onTimeout(timeoutMillis);
        }
        catch (HttpException ex) {
            this.streamMultiplexer.onException((Exception)((Object)ex));
        }
    }

    public void exception(IOSession session, Exception cause) {
        this.streamMultiplexer.onException(cause);
    }

    public void disconnected(IOSession session) {
        this.streamMultiplexer.onDisconnect();
    }

    public void close() throws IOException {
        this.streamMultiplexer.close();
    }

    public void close(CloseMode closeMode) {
        this.streamMultiplexer.close(closeMode);
    }

    public boolean isOpen() {
        return this.streamMultiplexer.isOpen();
    }

    public void setSocketTimeoutMillis(int timeout) {
        this.streamMultiplexer.setSocketTimeoutMillis(timeout);
    }

    public SSLSession getSSLSession() {
        return this.streamMultiplexer.getSSLSession();
    }

    public EndpointDetails getEndpointDetails() {
        return this.streamMultiplexer.getEndpointDetails();
    }

    public int getSocketTimeoutMillis() {
        return this.streamMultiplexer.getSocketTimeoutMillis();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.streamMultiplexer.getProtocolVersion();
    }

    public SocketAddress getRemoteAddress() {
        return this.streamMultiplexer.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.streamMultiplexer.getLocalAddress();
    }

    public String toString() {
        return this.streamMultiplexer.toString();
    }
}

