/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.framework;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.hc.core5.testing.framework.TestingFramework;
import org.apache.hc.core5.testing.framework.TestingFrameworkException;

public class TestingFrameworkRequestHandler
implements HttpRequestHandler {
    protected Throwable thrown;
    protected Map<String, Object> requestExpectations;
    protected Map<String, Object> desiredResponse;

    public void setRequestExpectations(Map<String, Object> requestExpectations) throws TestingFrameworkException {
        this.requestExpectations = (Map)TestingFramework.deepcopy(requestExpectations);
    }

    public void setDesiredResponse(Map<String, Object> desiredResponse) throws TestingFrameworkException {
        this.desiredResponse = (Map)TestingFramework.deepcopy(desiredResponse);
    }

    public void assertNothingThrown() throws TestingFrameworkException {
        if (this.thrown != null) {
            TestingFrameworkException e = this.thrown instanceof TestingFrameworkException ? (TestingFrameworkException)this.thrown : new TestingFrameworkException(this.thrown);
            this.thrown = null;
            throw e;
        }
    }

    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            Map map;
            ProtocolVersion protocolVersion;
            ProtocolVersion protocolVersion2;
            String expectedContentType;
            HttpEntity entity;
            String string;
            HttpEntity entity2;
            String data;
            String expectedBody;
            Map expectedHeaders;
            Map expectedQuery;
            String actualMethod = request.getMethod();
            String expectedMethod = (String)this.requestExpectations.get("method");
            if (!actualMethod.equals(expectedMethod)) {
                throw new TestingFrameworkException("Method not expected.  expected=" + expectedMethod + "; actual=" + actualMethod);
            }
            Object desiredStatus = this.desiredResponse.get("status");
            if (desiredStatus != null) {
                response.setCode(((Integer)desiredStatus).intValue());
            }
            if ((expectedQuery = (Map)this.requestExpectations.get("query")) != null) {
                URI uri = request.getUri();
                List actualParams = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
                HashMap<String, String> actualParamsMap = new HashMap<String, String>();
                for (NameValuePair nameValuePair : actualParams) {
                    actualParamsMap.put(nameValuePair.getName(), nameValuePair.getValue());
                }
                for (Map.Entry entry : expectedQuery.entrySet()) {
                    String expectedParamValue;
                    String key = (String)entry.getKey();
                    if (!actualParamsMap.containsKey(key)) {
                        throw new TestingFrameworkException("Expected parameter not found: " + key);
                    }
                    String actualParamValue = (String)actualParamsMap.get(key);
                    if (actualParamValue.equals(expectedParamValue = (String)entry.getValue())) continue;
                    throw new TestingFrameworkException("Expected parameter value not found.  Parameter=" + key + "; expected=" + expectedParamValue + "; actual=" + actualParamValue);
                }
            }
            if ((expectedHeaders = (Map)this.requestExpectations.get("headers")) != null) {
                Header[] actualHeaders;
                HashMap<String, String> actualHeadersMap = new HashMap<String, String>();
                for (Header header : actualHeaders = request.getAllHeaders()) {
                    actualHeadersMap.put(header.getName(), header.getValue());
                }
                for (Map.Entry entry : expectedHeaders.entrySet()) {
                    String expectedHeaderValue;
                    String key = (String)entry.getKey();
                    if (!actualHeadersMap.containsKey(key)) {
                        throw new TestingFrameworkException("Expected header not found: " + key);
                    }
                    String actualHeaderValue = (String)actualHeadersMap.get(key);
                    if (actualHeaderValue.equals(expectedHeaderValue = (String)entry.getValue())) continue;
                    throw new TestingFrameworkException("Expected header value not found.  Name=" + key + "; expected=" + expectedHeaderValue + "; actual=" + actualHeaderValue);
                }
            }
            if ((expectedBody = (String)this.requestExpectations.get("body")) != null && !(data = EntityUtils.toString((HttpEntity)(entity2 = request.getEntity()))).equals(expectedBody)) {
                throw new TestingFrameworkException("Expected body not found.  Body=" + data + "; expected=" + expectedBody);
            }
            String requestContentType = (String)this.requestExpectations.get("contentType");
            if (requestContentType != null && !(string = (entity = request.getEntity()).getContentType()).equals(expectedContentType = (String)this.requestExpectations.get("contentType"))) {
                throw new TestingFrameworkException("Expected request content type not found.  Content Type=" + string + "; expected=" + expectedContentType);
            }
            if (this.requestExpectations.containsKey("protocolVersion") && !(protocolVersion2 = request.getVersion()).equals((Object)(protocolVersion = (ProtocolVersion)this.requestExpectations.get("protocolVersion")))) {
                throw new TestingFrameworkException("Expected request protocol version not found.  Protocol Version=" + protocolVersion2 + "; expected=" + protocolVersion);
            }
            String desiredBody = (String)this.desiredResponse.get("body");
            if (desiredBody != null) {
                String string2 = (String)this.desiredResponse.get("contentType");
                StringEntity entity3 = string2 != null ? new StringEntity(desiredBody, ContentType.parse((CharSequence)string2)) : new StringEntity(desiredBody);
                response.setEntity((HttpEntity)entity3);
            }
            if ((map = (Map)this.desiredResponse.get("headers")) != null) {
                for (Map.Entry entry : map.entrySet()) {
                    response.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Throwable t) {
            this.thrown = t;
        }
    }
}

