/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.text.NumberFormat;
import org.apache.hc.core5.benchmark.BenchmarkWorker;
import org.apache.hc.core5.benchmark.Results;
import org.apache.hc.core5.benchmark.Stats;
import org.apache.hc.core5.http.HttpHost;

public class ResultProcessor {
    static NumberFormat nf2 = NumberFormat.getInstance();
    static NumberFormat nf3 = NumberFormat.getInstance();
    static NumberFormat nf6 = NumberFormat.getInstance();

    private ResultProcessor() {
    }

    static Results collectResults(BenchmarkWorker[] workers, HttpHost host, String uri) {
        long totalTimeNano = 0L;
        long successCount = 0L;
        long failureCount = 0L;
        long writeErrors = 0L;
        long keepAliveCount = 0L;
        long totalBytesRcvd = 0L;
        long totalBytesSent = 0L;
        Stats stats = workers[0].getStats();
        for (BenchmarkWorker worker : workers) {
            Stats s = worker.getStats();
            totalTimeNano += s.getDuration();
            successCount += (long)s.getSuccessCount();
            failureCount += (long)s.getFailureCount();
            writeErrors += (long)s.getWriteErrors();
            keepAliveCount += (long)s.getKeepAliveCount();
            totalBytesRcvd += s.getTotalBytesRecv();
            totalBytesSent += s.getTotalBytesSent();
        }
        Results results = new Results();
        results.serverName = stats.getServerName();
        results.hostName = host.getHostName();
        results.hostPort = host.getPort() > 0 ? host.getPort() : (host.getSchemeName().equalsIgnoreCase("https") ? 443 : 80);
        results.documentPath = uri;
        results.contentLength = stats.getContentLength();
        results.concurrencyLevel = workers.length;
        results.totalTimeNano = totalTimeNano;
        results.successCount = successCount;
        results.failureCount = failureCount;
        results.writeErrors = writeErrors;
        results.keepAliveCount = keepAliveCount;
        results.totalBytesRcvd = totalBytesRcvd;
        results.totalBytesSent = totalBytesSent;
        results.totalBytes = totalBytesRcvd + (totalBytesSent > 0L ? totalBytesSent : 0L);
        return results;
    }

    static void printResults(Results results) {
        int threads = results.getConcurrencyLevel();
        double totalTimeMs = results.getTotalTimeNano() / (long)threads / 1000000L;
        double timePerReqMs = totalTimeMs / (double)results.getSuccessCount();
        double totalTimeSec = totalTimeMs / 1000.0;
        double reqsPerSec = (double)results.getSuccessCount() / totalTimeSec;
        System.out.println("\nServer Software:\t\t" + results.getServerName());
        System.out.println("Server Hostname:\t\t" + results.getHostName());
        System.out.println("Server Port:\t\t\t" + Integer.valueOf(results.getHostPort()));
        System.out.println("Document Path:\t\t\t" + results.getDocumentPath());
        System.out.println("Document Length:\t\t" + results.getContentLength() + " bytes\n");
        System.out.println("Concurrency Level:\t\t" + results.getConcurrencyLevel());
        System.out.println("Time taken for tests:\t\t" + nf6.format(totalTimeSec) + " seconds");
        System.out.println("Complete requests:\t\t" + results.getSuccessCount());
        System.out.println("Failed requests:\t\t" + results.getFailureCount());
        System.out.println("Write errors:\t\t\t" + results.getWriteErrors());
        System.out.println("Kept alive:\t\t\t" + results.getKeepAliveCount());
        System.out.println("Total transferred:\t\t" + results.getTotalBytes() + " bytes");
        System.out.println("Requests per second:\t\t" + nf2.format(reqsPerSec) + " [#/sec] (mean)");
        System.out.println("Time per request:\t\t" + nf3.format(timePerReqMs * (double)results.getConcurrencyLevel()) + " [ms] (mean)");
        System.out.println("Time per request:\t\t" + nf3.format(timePerReqMs) + " [ms] (mean, across all concurrent requests)");
        System.out.println("Transfer rate:\t\t\t" + nf2.format((double)(results.getTotalBytesRcvd() / 1000L) / totalTimeSec) + " [Kbytes/sec] received");
        System.out.println("\t\t\t\t" + (results.getTotalBytesSent() > 0L ? nf2.format((double)(results.getTotalBytesSent() / 1000L) / totalTimeSec) : Integer.valueOf(-1)) + " kb/s sent");
        System.out.println("\t\t\t\t" + nf2.format((double)(results.getTotalBytes() / 1000L) / totalTimeSec) + " kb/s total");
    }

    static {
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf3.setMaximumFractionDigits(3);
        nf3.setMinimumFractionDigits(3);
        nf6.setMaximumFractionDigits(6);
        nf6.setMinimumFractionDigits(6);
    }
}

