/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.net.SocketFactory;
import org.apache.hc.core5.benchmark.BenchmarkConnection;
import org.apache.hc.core5.benchmark.Config;
import org.apache.hc.core5.benchmark.DefaultHeader;
import org.apache.hc.core5.benchmark.Stats;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.io.CloseMode;

class BenchmarkWorker
implements Runnable {
    private final byte[] buffer = new byte[4096];
    private final HttpCoreContext context;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor httpexecutor;
    private final ConnectionReuseStrategy connstrategy;
    private final HttpHost host;
    private final ClassicHttpRequest request;
    private final Config config;
    private final SocketFactory socketFactory;
    private boolean shutdownSignal;
    private final Stats stats = new Stats();

    public BenchmarkWorker(HttpHost host, ClassicHttpRequest request, SocketFactory socketFactory, Config config) {
        this.context = new HttpCoreContext();
        this.host = host;
        this.request = request;
        this.config = config;
        HttpProcessorBuilder builder = HttpProcessorBuilder.create().addAll(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("HttpCore-AB/1.1")});
        if (this.config.isUseExpectContinue()) {
            builder.add((HttpRequestInterceptor)new RequestExpectContinue());
        }
        this.httpProcessor = builder.build();
        this.httpexecutor = new HttpRequestExecutor();
        this.connstrategy = DefaultConnectionReuseStrategy.INSTANCE;
        this.socketFactory = socketFactory;
        this.shutdownSignal = false;
    }

    @Override
    public void run() {
        block22: {
            Header header;
            ClassicHttpResponse response = null;
            HttpVersion version = this.config.isUseHttp1_0() ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
            BenchmarkConnection conn = new BenchmarkConnection(H1Config.DEFAULT, this.stats);
            String scheme = this.host.getSchemeName();
            String hostname = this.host.getHostName();
            int port = this.host.getPort();
            if (port == -1) {
                port = scheme.equalsIgnoreCase("https") ? 443 : 80;
            }
            this.context.setProtocolVersion((ProtocolVersion)version);
            this.stats.start();
            int count = this.config.getRequests();
            for (int i = 0; i < count; ++i) {
                block21: {
                    try {
                        BenchmarkWorker.resetHeader(this.request);
                        if (!conn.isOpen()) {
                            Socket socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
                            int timeoutMillis = this.config.getSocketTimeoutMillis();
                            socket.setSoTimeout(timeoutMillis);
                            socket.connect(new InetSocketAddress(hostname, port), timeoutMillis);
                            conn.bind(socket);
                        }
                        try {
                            this.httpexecutor.preProcess(this.request, this.httpProcessor, (HttpContext)this.context);
                            response = this.httpexecutor.execute(this.request, (HttpClientConnection)conn, (HttpContext)this.context);
                            this.httpexecutor.postProcess(response, this.httpProcessor, (HttpContext)this.context);
                        }
                        catch (HttpException e) {
                            this.stats.incWriteErrors();
                            if (this.config.getVerbosity() >= 2) {
                                System.err.println("Failed HTTP request : " + e.getMessage());
                            }
                            conn.close(CloseMode.IMMEDIATE);
                            continue;
                        }
                        this.verboseOutput(response);
                        if (response.getCode() == 200) {
                            this.stats.incSuccessCount();
                        } else {
                            this.stats.incFailureCount();
                        }
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            int l;
                            ContentType ct = EntityUtils.getContentTypeOrDefault((HttpEntity)entity);
                            Charset charset = ct.getCharset();
                            if (charset == null) {
                                charset = StandardCharsets.ISO_8859_1;
                            }
                            long contentLen = 0L;
                            InputStream inStream = entity.getContent();
                            while ((l = inStream.read(this.buffer)) != -1) {
                                contentLen += (long)l;
                                if (this.config.getVerbosity() < 4) continue;
                                String s = new String(this.buffer, 0, l, charset);
                                System.out.print(s);
                            }
                            inStream.close();
                            this.stats.setContentLength(contentLen);
                        }
                        if (this.config.getVerbosity() >= 4) {
                            System.out.println();
                            System.out.println();
                        }
                        if (!(this.config.isKeepAlive() && conn.isConsistent() && this.connstrategy.keepAlive((HttpRequest)this.request, (HttpResponse)response, (HttpContext)this.context))) {
                            conn.close();
                        } else {
                            this.stats.incKeepAliveCount();
                        }
                    }
                    catch (IOException ex) {
                        this.stats.incFailureCount();
                        if (this.config.getVerbosity() >= 2) {
                            System.err.println("I/O error: " + ex.getMessage());
                        }
                    }
                    catch (Exception ex) {
                        this.stats.incFailureCount();
                        if (this.config.getVerbosity() < 2) break block21;
                        System.err.println("Generic error: " + ex.getMessage());
                    }
                }
                if (this.shutdownSignal) break;
            }
            this.stats.finish();
            if (response != null && (header = response.getFirstHeader("Server")) != null) {
                this.stats.setServerName(header.getValue());
            }
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.stats.incFailureCount();
                if (this.config.getVerbosity() < 2) break block22;
                System.err.println("I/O error: " + ex.getMessage());
            }
        }
    }

    private void verboseOutput(ClassicHttpResponse response) {
        Header[] headers;
        if (this.config.getVerbosity() >= 3) {
            System.out.println(">> " + this.request.getMethod() + " " + this.request.getRequestUri());
            for (Header header : headers = this.request.getAllHeaders()) {
                System.out.println(">> " + header.toString());
            }
            System.out.println();
        }
        if (this.config.getVerbosity() >= 2) {
            System.out.println(response.getCode());
        }
        if (this.config.getVerbosity() >= 3) {
            System.out.println("<< " + response.getCode() + " " + response.getReasonPhrase());
            for (Header header : headers = response.getAllHeaders()) {
                System.out.println("<< " + header.toString());
            }
            System.out.println();
        }
    }

    private static void resetHeader(ClassicHttpRequest request) {
        Iterator it = request.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (header instanceof DefaultHeader) continue;
            it.remove();
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    public synchronized void setShutdownSignal() {
        this.shutdownSignal = true;
    }
}

