/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

class IOSessionImpl
implements IOSession {
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final SelectionKey key;
    private final SocketChannel channel;
    private final String id;
    private final AtomicInteger status;
    private final Deque<Command> commandQueue;
    private volatile IOEventHandler eventHandler;
    private volatile int socketTimeout;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;

    public IOSessionImpl(SelectionKey key, SocketChannel socketChannel) {
        this.key = Args.notNull(key, "Selection key");
        this.channel = Args.notNull(socketChannel, "Socket channel");
        this.commandQueue = new ConcurrentLinkedDeque<Command>();
        this.socketTimeout = 0;
        this.id = String.format("i/o-%08X", COUNT.getAndIncrement());
        this.status = new AtomicInteger(0);
        this.lastReadTime = System.currentTimeMillis();
        this.lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IOEventHandler getHandler() {
        return this.eventHandler;
    }

    @Override
    public void setHandler(IOEventHandler handler) {
        this.eventHandler = handler;
    }

    @Override
    public void addLast(Command command) {
        this.commandQueue.addLast(command);
        this.setEvent(4);
    }

    @Override
    public void addFirst(Command command) {
        this.commandQueue.addFirst(command);
        this.setEvent(4);
    }

    @Override
    public Command getCommand() {
        return this.commandQueue.poll();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.socket().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.socket().getRemoteSocketAddress();
    }

    @Override
    public int getEventMask() {
        return this.key.interestOps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventMask(int newValue) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            this.key.interestOps(newValue);
            this.key.selector().wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEvent(int op) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            this.key.interestOps(this.key.interestOps() | op);
            this.key.selector().wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEvent(int op) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            this.key.interestOps(this.key.interestOps() & ~op);
            this.key.selector().wakeup();
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    @Override
    public void updateReadTime() {
        this.lastReadTime = System.currentTimeMillis();
    }

    @Override
    public void updateWriteTime() {
        this.lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(0, Integer.MAX_VALUE)) {
            this.key.cancel();
            this.key.attach(null);
            try {
                this.key.channel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.key.selector().isOpen()) {
                this.key.selector().wakeup();
            }
        }
    }

    @Override
    public int getStatus() {
        return this.status.get();
    }

    @Override
    public boolean isClosed() {
        return this.status.get() == Integer.MAX_VALUE || !this.channel.isOpen();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.close();
    }

    private static void formatOps(StringBuilder buffer, int ops) {
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.id).append("[");
        switch (this.status.get()) {
            case 0: {
                buffer.append("ACTIVE");
                break;
            }
            case 1: {
                buffer.append("CLOSING");
                break;
            }
            case 0x7FFFFFFF: {
                buffer.append("CLOSED");
            }
        }
        buffer.append("][");
        if (this.key.isValid()) {
            IOSessionImpl.formatOps(buffer, this.key.interestOps());
            buffer.append(":");
            IOSessionImpl.formatOps(buffer, this.key.readyOps());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

