/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequester;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http2.impl.nio.bootstrap.CancellableExecution;
import org.apache.hc.core5.http2.nio.pool.H2ConnPool;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class Http2MultiplexingRequester
extends AsyncRequester {
    private final H2ConnPool connPool;

    public Http2MultiplexingRequester(IOReactorConfig ioReactorConfig, IOEventHandlerFactory eventHandlerFactory, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
        super(eventHandlerFactory, ioReactorConfig, ioSessionDecorator, sessionListener, (Callback)new Callback<IOSession>(){

            public void execute(IOSession session) {
                session.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
            }
        }, (Resolver)DefaultAddressResolver.INSTANCE);
        this.connPool = new H2ConnPool((ConnectionInitiator)this, addressResolver, tlsStrategy);
    }

    public void closeIdle(TimeValue idleTime) {
        this.connPool.closeIdle(idleTime);
    }

    public Set<HttpHost> getRoutes() {
        return this.connPool.getRoutes();
    }

    public TimeValue getValidateAfterInactivity() {
        return this.connPool.getValidateAfterInactivity();
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.connPool.setValidateAfterInactivity(timeValue);
    }

    public Cancellable execute(AsyncClientExchangeHandler exchangeHandler, Timeout timeout, HttpContext context) {
        Args.notNull((Object)exchangeHandler, (String)"Exchange handler");
        Args.notNull((Object)timeout, (String)"Timeout");
        Args.notNull((Object)context, (String)"Context");
        CancellableExecution cancellableExecution = new CancellableExecution();
        this.execute(exchangeHandler, cancellableExecution, timeout, context);
        return cancellableExecution;
    }

    private void execute(final AsyncClientExchangeHandler exchangeHandler, final CancellableDependency cancellableDependency, final Timeout timeout, final HttpContext context) {
        Args.notNull((Object)exchangeHandler, (String)"Exchange handler");
        Args.notNull((Object)timeout, (String)"Timeout");
        Args.notNull((Object)context, (String)"Context");
        try {
            exchangeHandler.produceRequest(new RequestChannel(){

                public void sendRequest(final HttpRequest request, final EntityDetails entityDetails) throws HttpException, IOException {
                    String scheme = request.getScheme();
                    URIAuthority authority = request.getAuthority();
                    if (authority == null) {
                        throw new ProtocolException("Request authority not specified");
                    }
                    HttpHost target = new HttpHost((NamedEndpoint)authority, scheme);
                    Http2MultiplexingRequester.this.connPool.getSession(target, timeout, (FutureCallback)new FutureCallback<IOSession>(){

                        public void completed(IOSession ioSession) {
                            ioSession.addLast((Command)new ExecutionCommand(new AsyncClientExchangeHandler(){

                                public void releaseResources() {
                                    exchangeHandler.releaseResources();
                                }

                                public void produceRequest(RequestChannel channel) throws HttpException, IOException {
                                    channel.sendRequest(request, entityDetails);
                                }

                                public int available() {
                                    return exchangeHandler.available();
                                }

                                public void produce(DataStreamChannel channel) throws IOException {
                                    exchangeHandler.produce(channel);
                                }

                                public void consumeInformation(HttpResponse response) throws HttpException, IOException {
                                    exchangeHandler.consumeInformation(response);
                                }

                                public void consumeResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                                    exchangeHandler.consumeResponse(response, entityDetails);
                                }

                                public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                                    exchangeHandler.updateCapacity(capacityChannel);
                                }

                                public int consume(ByteBuffer src) throws IOException {
                                    return exchangeHandler.consume(src);
                                }

                                public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                                    exchangeHandler.streamEnd(trailers);
                                }

                                public void cancel() {
                                    exchangeHandler.cancel();
                                }

                                public void failed(Exception cause) {
                                    exchangeHandler.failed(cause);
                                }
                            }, cancellableDependency, context));
                        }

                        public void failed(Exception ex) {
                            exchangeHandler.failed(ex);
                        }

                        public void cancelled() {
                            exchangeHandler.cancel();
                        }
                    });
                }
            });
        }
        catch (IOException | HttpException ex) {
            exchangeHandler.failed((Exception)ex);
        }
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, Timeout timeout, HttpContext context, FutureCallback<T> callback) {
        Args.notNull((Object)requestProducer, (String)"Request producer");
        Args.notNull(responseConsumer, (String)"Response consumer");
        Args.notNull((Object)timeout, (String)"Timeout");
        final ComplexFuture future = new ComplexFuture(callback);
        BasicClientExchangeHandler exchangeHandler = new BasicClientExchangeHandler(requestProducer, responseConsumer, new FutureCallback<T>(){

            public void completed(T result) {
                future.completed(result);
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }

            public void cancelled() {
                future.cancel();
            }
        });
        this.execute((AsyncClientExchangeHandler)exchangeHandler, (CancellableDependency)future, timeout, (HttpContext)(context != null ? context : HttpCoreContext.create()));
        return future;
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, Timeout timeout, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, timeout, null, callback);
    }
}

