/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

abstract class AbstractSingleCoreIOReactor
implements IOReactor {
    private final Queue<ExceptionEvent> auditLog;
    private final AtomicReference<IOReactorStatus> status;
    private final Object shutdownMutex;
    final Selector selector;

    AbstractSingleCoreIOReactor(Queue<ExceptionEvent> auditLog) {
        this.auditLog = auditLog;
        this.shutdownMutex = new Object();
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected failure opening I/O selector", ex);
        }
    }

    @Override
    public final IOReactorStatus getStatus() {
        return this.status.get();
    }

    void addExceptionEvent(Throwable ex) {
        this.auditLog.add(new ExceptionEvent(ex, new Date()));
    }

    abstract void doExecute() throws IOException;

    abstract void doTerminate() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (!this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) return;
        try {
            this.doExecute();
            return;
        }
        catch (ClosedSelectorException ignore) {
            try {
                this.doTerminate();
                Set<SelectionKey> keys = this.selector.keys();
                Iterator<SelectionKey> i$ = keys.iterator();
                while (i$.hasNext()) {
                    SelectionKey key = i$.next();
                    Closeable closeable = (Closeable)key.attachment();
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (IOException ex) {
                            this.addExceptionEvent(ex);
                        }
                    }
                    key.channel().close();
                }
                try {
                    this.selector.close();
                    return;
                }
                catch (IOException ex) {
                    this.addExceptionEvent(ex);
                    return;
                }
            }
            catch (Exception ex) {
                this.addExceptionEvent(ex);
                return;
            }
            finally {
                this.status.set(IOReactorStatus.SHUT_DOWN);
                Object ex = this.shutdownMutex;
                synchronized (ex) {
                    this.shutdownMutex.notifyAll();
                }
            }
        }
        catch (Exception ex) {
            this.addExceptionEvent(ex);
            return;
        }
        finally {
            try {
                this.doTerminate();
                Set<SelectionKey> keys = this.selector.keys();
                Iterator<SelectionKey> i$ = keys.iterator();
                while (i$.hasNext()) {
                    SelectionKey key = i$.next();
                    Closeable closeable = (Closeable)key.attachment();
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (IOException ex) {
                            this.addExceptionEvent(ex);
                        }
                    }
                    key.channel().close();
                }
                try {
                    this.selector.close();
                }
                catch (IOException ex) {
                    this.addExceptionEvent(ex);
                }
            }
            catch (Exception ex) {
                this.addExceptionEvent(ex);
            }
            finally {
                this.status.set(IOReactorStatus.SHUT_DOWN);
                Object object = this.shutdownMutex;
                synchronized (object) {
                    this.shutdownMutex.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        Args.notNull(waitTime, "Wait time");
        long deadline = System.currentTimeMillis() + waitTime.toMillis();
        long remaining = waitTime.toMillis();
        Object object = this.shutdownMutex;
        synchronized (object) {
            while (this.status.get().compareTo(IOReactorStatus.SHUT_DOWN) < 0) {
                this.shutdownMutex.wait(remaining);
                remaining = deadline - System.currentTimeMillis();
                if (remaining > 0L) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.SHUT_DOWN)) {
            Object object = this.shutdownMutex;
            synchronized (object) {
                this.shutdownMutex.notifyAll();
            }
        } else if (this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown(ShutdownType shutdownType) {
        if (shutdownType == ShutdownType.GRACEFUL) {
            this.initiateShutdown();
            try {
                this.awaitShutdown(TimeValue.ofSeconds(5L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            IOReactorStatus previousStatus = this.status.getAndSet(IOReactorStatus.SHUT_DOWN);
            if (previousStatus.compareTo(IOReactorStatus.ACTIVE) == 0) {
                this.selector.wakeup();
            }
            Object object = this.shutdownMutex;
            synchronized (object) {
                this.shutdownMutex.notifyAll();
            }
        }
    }

    @Override
    public final void close() {
        this.shutdown(ShutdownType.GRACEFUL);
    }
}

