/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.util.Args;

public abstract class AbstractAsyncResponseConsumer<T, E>
implements AsyncResponseConsumer<T> {
    private final AsyncEntityConsumer<E> entityConsumer;
    private volatile T result;

    public AbstractAsyncResponseConsumer(AsyncEntityConsumer<E> entityConsumer) {
        Args.notNull(entityConsumer, "Entity consumer");
        this.entityConsumer = entityConsumer;
    }

    protected abstract T buildResult(HttpResponse var1, E var2, ContentType var3);

    @Override
    public final void consumeResponse(final HttpResponse response, final EntityDetails entityDetails, final FutureCallback<T> resultCallback) throws HttpException, IOException {
        if (entityDetails != null) {
            this.entityConsumer.streamStart(entityDetails, new FutureCallback<E>(){

                @Override
                public void completed(E entity) {
                    try {
                        ContentType contentType = ContentType.parse(entityDetails.getContentType());
                        AbstractAsyncResponseConsumer.this.result = AbstractAsyncResponseConsumer.this.buildResult(response, entity, contentType);
                        resultCallback.completed(AbstractAsyncResponseConsumer.this.result);
                    }
                    catch (UnsupportedCharsetException ex) {
                        resultCallback.failed(ex);
                    }
                }

                @Override
                public void failed(Exception ex) {
                    resultCallback.failed(ex);
                }

                @Override
                public void cancelled() {
                    resultCallback.cancelled();
                }
            });
        } else {
            this.result = this.buildResult(response, null, null);
            resultCallback.completed(this.result);
            this.entityConsumer.releaseResources();
        }
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.entityConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final int consume(ByteBuffer src) throws IOException {
        return this.entityConsumer.consume(src);
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.entityConsumer.streamEnd(trailers);
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public final void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        this.entityConsumer.releaseResources();
    }
}

