/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.net.SocketAddress;
import org.apache.hc.core5.net.InetAddressUtils;

public abstract class EndpointDetails {
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;

    protected EndpointDetails(SocketAddress remoteAddress, SocketAddress localAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public abstract long getRequestCount();

    public abstract long getResponseCount();

    public abstract long getSentBytesCount();

    public abstract long getReceivedBytesCount();

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        InetAddressUtils.formatAddress(buffer, this.localAddress);
        buffer.append("<->");
        InetAddressUtils.formatAddress(buffer, this.remoteAddress);
        return buffer.toString();
    }
}

