/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.testing.classic.LoggingSocketHolder;
import org.apache.hc.core5.testing.classic.Wire;
import org.apache.hc.core5.util.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBHttpServerConnection
extends DefaultBHttpServerConnection
implements Identifiable {
    private static final AtomicLong COUNT = new AtomicLong();
    private final String id = "http-incoming-" + COUNT.incrementAndGet();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Logger headerlog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.headers");
    private final Wire wire = new Wire(LoggerFactory.getLogger((String)"org.apache.hc.core5.http.wire"), this.id);

    public LoggingBHttpServerConnection(String scheme, H1Config h1Config, CharsetDecoder chardecoder, CharsetEncoder charencoder, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<ClassicHttpRequest> requestParserFactory, HttpMessageWriterFactory<ClassicHttpResponse> responseWriterFactory) {
        super(scheme, h1Config, chardecoder, charencoder, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
    }

    public String getId() {
        return this.id;
    }

    public LoggingBHttpServerConnection(String scheme, H1Config h1Config) {
        this(scheme, h1Config, null, null, null, null, null, null);
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + ": Close connection");
        }
        super.close();
    }

    public void shutdown(ShutdownType shutdownType) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + ": Shutdown connection");
        }
        super.shutdown(shutdownType);
    }

    public void bind(Socket socket) throws IOException {
        super.bind((SocketHolder)(this.wire.isEnabled() ? new LoggingSocketHolder(socket, this.wire) : new SocketHolder(socket)));
    }

    protected void onRequestReceived(ClassicHttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " >> " + new RequestLine((HttpRequest)request));
            for (Header header : headers = request.getAllHeaders()) {
                this.headerlog.debug(this.id + " >> " + header.toString());
            }
        }
    }

    protected void onResponseSubmitted(ClassicHttpResponse response) {
        if (response != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " << " + new StatusLine((HttpResponse)response));
            for (Header header : headers = response.getAllHeaders()) {
                this.headerlog.debug(this.id + " << " + header.toString());
            }
        }
    }
}

