/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.BufferedData;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientH2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Internal
public class ClientHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private final ProtocolIOSession ioSession;
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final AtomicReference<HttpConnectionEventHandler> protocolHandlerRef;
    private volatile ByteBuffer preface;
    private volatile BufferedData inBuf;

    public ClientHttpProtocolNegotiator(ProtocolIOSession ioSession, ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy) {
        this.ioSession = (ProtocolIOSession)Args.notNull((Object)ioSession, (String)"I/O session");
        this.http1StreamHandlerFactory = (ClientHttp1StreamDuplexerFactory)Args.notNull((Object)http1StreamHandlerFactory, (String)"HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = (ClientH2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.protocolHandlerRef = new AtomicReference<Object>(null);
    }

    private void startHttp1(IOSession session) {
        ClientHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(this.ioSession);
        ClientHttp1IOEventHandler protocolHandler = new ClientHttp1IOEventHandler(http1StreamHandler);
        try {
            this.ioSession.upgrade((IOEventHandler)protocolHandler);
            this.protocolHandlerRef.set((HttpConnectionEventHandler)protocolHandler);
            protocolHandler.connected(session);
            if (this.inBuf != null) {
                protocolHandler.inputReady(session, this.inBuf.data());
                this.inBuf.clear();
            }
        }
        catch (Exception ex) {
            protocolHandler.exception(session, ex);
            session.close(CloseMode.IMMEDIATE);
        }
    }

    private void startHttp2(IOSession session) {
        ClientH2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
        ClientH2IOEventHandler protocolHandler = new ClientH2IOEventHandler(streamMultiplexer);
        try {
            this.ioSession.upgrade((IOEventHandler)protocolHandler);
            this.protocolHandlerRef.set(protocolHandler);
            protocolHandler.connected(session);
            if (this.inBuf != null) {
                protocolHandler.inputReady(session, this.inBuf.data());
                this.inBuf.clear();
            }
        }
        catch (Exception ex) {
            protocolHandler.exception(session, ex);
            session.close(CloseMode.IMMEDIATE);
        }
    }

    private void writeOutPreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            IOSession channel = session;
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            session.clearEvent(4);
            this.startHttp2(session);
        } else {
            session.setEvent(4);
        }
    }

    public void connected(IOSession session) throws IOException {
        switch (this.versionPolicy) {
            case NEGOTIATE: {
                TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                if (tlsDetails == null || !ApplicationProtocols.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                this.preface = ByteBuffer.wrap(PREFACE);
                break;
            }
            case FORCE_HTTP_2: {
                this.preface = ByteBuffer.wrap(PREFACE);
            }
        }
        if (this.preface == null) {
            this.startHttp1(session);
        } else {
            this.writeOutPreface(session);
        }
    }

    public void inputReady(IOSession session, ByteBuffer src) throws IOException {
        if (src != null) {
            if (this.inBuf == null) {
                this.inBuf = BufferedData.allocate((int)src.remaining());
            }
            this.inBuf.put(src);
        }
        this.outputReady(session);
    }

    public void outputReady(IOSession session) throws IOException {
        if (this.preface != null) {
            this.writeOutPreface(session);
        } else {
            session.close(CloseMode.GRACEFUL);
        }
    }

    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create((Timeout)timeout));
    }

    public void exception(IOSession session, Exception cause) {
        session.close(CloseMode.IMMEDIATE);
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        if (protocolHandler != null) {
            protocolHandler.exception(session, cause);
        } else {
            CommandSupport.failCommands((IOSession)session, (Exception)cause);
        }
    }

    public void disconnected(IOSession session) {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.getAndSet(null);
        if (protocolHandler != null) {
            protocolHandler.disconnected((IOSession)this.ioSession);
        } else {
            CommandSupport.cancelCommands((IOSession)session);
        }
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        return protocolHandler != null ? protocolHandler.getEndpointDetails() : null;
    }

    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        return protocolHandler != null ? protocolHandler.getProtocolVersion() : null;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    public void close() throws IOException {
        this.ioSession.close();
    }

    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    public String toString() {
        return "[versionPolicy=" + (Object)((Object)this.versionPolicy) + ']';
    }
}

