/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.DefaultFrameFactory;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.impl.nio.AbstractHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.Http2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.Http2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamHandler;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.util.Args;

public class ServerHttp2StreamMultiplexer
extends AbstractHttp2StreamMultiplexer {
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;

    public ServerHttp2StreamMultiplexer(TlsCapableIOSession ioSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config, Http2StreamListener streamListener) {
        super(AbstractHttp2StreamMultiplexer.Mode.SERVER, ioSession, frameFactory, StreamIdGenerator.EVEN, httpProcessor, charCodingConfig, h2Config, streamListener);
        this.exchangeHandlerFactory = Args.notNull(exchangeHandlerFactory, "Handler factory");
    }

    public ServerHttp2StreamMultiplexer(TlsCapableIOSession ioSession, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config) {
        this(ioSession, DefaultFrameFactory.INSTANCE, httpProcessor, exchangeHandlerFactory, charCodingConfig, h2Config, null);
    }

    @Override
    Http2StreamHandler createRemotelyInitiatedStream(Http2StreamChannel channel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics) throws IOException {
        HttpCoreContext context = HttpCoreContext.create();
        context.setAttribute("http.ssl-ession", this.getSSLSession());
        context.setAttribute("http.connection-endpoint", this.getEndpointDetails());
        return new ServerHttp2StreamHandler(channel, httpProcessor, connMetrics, this.exchangeHandlerFactory, context);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        InetAddressUtils.formatAddress(buffer, this.getRemoteAddress());
        buffer.append("->");
        InetAddressUtils.formatAddress(buffer, this.getLocalAddress());
        return buffer.toString();
    }
}

