/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class Http2OnlyClientProtocolNegotiator
implements HttpConnectionEventHandler {
    private final TlsCapableIOSession ioSession;
    private final ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final ByteBuffer preface;

    public Http2OnlyClientProtocolNegotiator(TlsCapableIOSession ioSession, ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.preface = ByteBuffer.wrap(ClientHttpProtocolNegotiator.PREFACE);
    }

    @Override
    public void connected(IOSession session) {
        try {
            String applicationProtocol;
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            if (tlsDetails != null && (applicationProtocol = tlsDetails.getApplicationProtocol()) != null && !ApplicationProtocols.HTTP_2.id.equals(applicationProtocol)) {
                throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected application protocol: " + applicationProtocol);
            }
            this.writePreface(session);
        }
        catch (Exception ex) {
            session.shutdown(ShutdownType.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    private void writePreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            ByteChannel channel = session.channel();
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            ClientHttp2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
            ClientHttp2IOEventHandler newHandler = new ClientHttp2IOEventHandler(streamMultiplexer);
            newHandler.connected(session);
            session.setHandler(newHandler);
        }
    }

    @Override
    public void inputReady(IOSession session) {
        this.outputReady(session);
    }

    @Override
    public void outputReady(IOSession session) {
        try {
            if (this.preface != null) {
                this.writePreface(session);
            } else {
                session.shutdown(ShutdownType.IMMEDIATE);
            }
        }
        catch (IOException ex) {
            session.shutdown(ShutdownType.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    @Override
    public void timeout(IOSession session) {
        this.exception(session, new SocketTimeoutException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(IOSession session, Exception cause) {
        try {
            Command command;
            while ((command = this.ioSession.getCommand()) != null) {
                if (command instanceof ExecutionCommand) {
                    ExecutionCommand executionCommand = (ExecutionCommand)command;
                    AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                    exchangeHandler.failed(cause);
                    exchangeHandler.releaseResources();
                    continue;
                }
                command.cancel();
            }
        }
        finally {
            session.shutdown(ShutdownType.IMMEDIATE);
        }
    }

    @Override
    public void disconnected(IOSession session) {
        Command command;
        while ((command = this.ioSession.getCommand()) != null) {
            if (command instanceof ExecutionCommand) {
                ExecutionCommand executionCommand = (ExecutionCommand)command;
                AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                exchangeHandler.failed(new ConnectionClosedException("Connection closed"));
                exchangeHandler.releaseResources();
                continue;
            }
            command.cancel();
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.ioSession.shutdown(shutdownType);
    }
}

