/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.nio.ByteBuffer;
import org.apache.hc.core5.reactor.ssl.SSLBuffer;
import org.apache.hc.core5.util.Args;

public abstract class SSLBufferManagement {
    public static final SSLBufferManagement STATIC = new StaticSSLBufferManagement();
    public static final SSLBufferManagement DYNAMIC = new DynamicSSLBufferManagement();

    public abstract SSLBuffer create(int var1);

    static SSLBuffer create(SSLBufferManagement mode, int size) {
        if (mode == null) {
            return STATIC.create(size);
        }
        return mode.create(size);
    }

    private static final class DynamicBuffer
    implements SSLBuffer {
        private ByteBuffer wrapped;
        private final int length;

        public DynamicBuffer(int size) {
            Args.positive(size, "size");
            this.length = size;
        }

        @Override
        public ByteBuffer acquire() {
            if (this.wrapped != null) {
                return this.wrapped;
            }
            this.wrapped = ByteBuffer.allocate(this.length);
            return this.wrapped;
        }

        @Override
        public void release() {
            this.wrapped = null;
        }

        @Override
        public boolean isAcquired() {
            return this.wrapped != null;
        }

        @Override
        public boolean hasData() {
            return this.wrapped != null && this.wrapped.position() > 0;
        }
    }

    private static final class DynamicSSLBufferManagement
    extends SSLBufferManagement {
        private DynamicSSLBufferManagement() {
        }

        @Override
        public SSLBuffer create(int size) {
            return new DynamicBuffer(size);
        }
    }

    private static final class StaticBuffer
    implements SSLBuffer {
        private final ByteBuffer buffer;

        public StaticBuffer(int size) {
            Args.positive(size, "size");
            this.buffer = ByteBuffer.allocate(size);
        }

        @Override
        public ByteBuffer acquire() {
            return this.buffer;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isAcquired() {
            return true;
        }

        @Override
        public boolean hasData() {
            return this.buffer.position() > 0;
        }
    }

    private static final class StaticSSLBufferManagement
    extends SSLBufferManagement {
        private StaticSSLBufferManagement() {
        }

        @Override
        public SSLBuffer create(int size) {
            return new StaticBuffer(size);
        }
    }
}

