/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;

abstract class InternalChannel
implements GracefullyCloseable {
    InternalChannel() {
    }

    abstract void onIOEvent(int var1) throws IOException;

    abstract void onTimeout() throws IOException;

    abstract void onException(Exception var1);

    abstract int getTimeout();

    abstract long getLastReadTime();

    final void handleIOEvent(int ops) {
        try {
            this.onIOEvent(ops);
        }
        catch (CancelledKeyException ex) {
            this.shutdown(ShutdownType.GRACEFUL);
        }
        catch (Exception ex) {
            this.onException(ex);
            this.shutdown(ShutdownType.IMMEDIATE);
        }
    }

    final boolean checkTimeout(long currentTime) {
        long deadline;
        int timeout = this.getTimeout();
        if (timeout > 0 && currentTime > (deadline = this.getLastReadTime() + (long)timeout)) {
            try {
                this.onTimeout();
            }
            catch (CancelledKeyException ex) {
                this.shutdown(ShutdownType.GRACEFUL);
            }
            catch (Exception ex) {
                this.onException(ex);
                this.shutdown(ShutdownType.IMMEDIATE);
            }
            return false;
        }
        return true;
    }
}

