/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ProtocolVersion;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpVersion
extends ProtocolVersion {
    private static final long serialVersionUID = -5856653513894415344L;
    public static final String HTTP = "HTTP";
    public static final HttpVersion HTTP_0_9 = new HttpVersion(0, 9);
    public static final HttpVersion HTTP_1_0 = new HttpVersion(1, 0);
    public static final HttpVersion HTTP_1_1 = new HttpVersion(1, 1);
    public static final HttpVersion HTTP_2_0;
    public static final HttpVersion HTTP_2;
    public static final HttpVersion DEFAULT;

    public HttpVersion(int major, int minor) {
        super(HTTP, major, minor);
    }

    @Override
    public ProtocolVersion forVersion(int major, int minor) {
        if (major == this.getMajor() && minor == this.getMinor()) {
            return this;
        }
        if (major == 1) {
            if (minor == 0) {
                return HTTP_1_0;
            }
            if (minor == 1) {
                return HTTP_1_1;
            }
        }
        if (major == 0 && minor == 9) {
            return HTTP_0_9;
        }
        return new HttpVersion(major, minor);
    }

    static {
        HTTP_2 = HTTP_2_0 = new HttpVersion(2, 0);
        DEFAULT = HTTP_1_1;
    }
}

