/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.io.File;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hc.core5.benchmark.BenchmarkWorker;
import org.apache.hc.core5.benchmark.CommandLineUtils;
import org.apache.hc.core5.benchmark.Config;
import org.apache.hc.core5.benchmark.DefaultHeader;
import org.apache.hc.core5.benchmark.ResultProcessor;
import org.apache.hc.core5.benchmark.Results;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;

public class HttpBenchmark {
    private final Config config;

    public static void main(String[] args) throws Exception {
        Options options = CommandLineUtils.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption('h') || cmd.getArgs().length != 1) {
            CommandLineUtils.showUsage(options);
            System.exit(1);
        }
        Config config = new Config();
        CommandLineUtils.parseCommandLine(cmd, config);
        if (config.getUrl() == null) {
            CommandLineUtils.showUsage(options);
            System.exit(1);
        }
        HttpBenchmark httpBenchmark = new HttpBenchmark(config);
        httpBenchmark.execute();
    }

    public HttpBenchmark(Config config) {
        this.config = config != null ? config : new Config();
    }

    private ClassicHttpRequest createRequest(HttpHost host) {
        String[] headers;
        BasicClassicHttpRequest request;
        URL url = this.config.getUrl();
        FileEntity entity = null;
        if (this.config.getPayloadFile() != null) {
            FileEntity fe = new FileEntity(this.config.getPayloadFile());
            fe.setContentType(this.config.getContentType());
            fe.setChunked(this.config.isUseChunking());
            entity = fe;
        } else if (this.config.getPayloadText() != null) {
            StringEntity se = new StringEntity(this.config.getPayloadText(), ContentType.parse((CharSequence)this.config.getContentType()));
            se.setChunked(this.config.isUseChunking());
            entity = se;
        }
        if ("POST".equals(this.config.getMethod())) {
            BasicClassicHttpRequest httppost = new BasicClassicHttpRequest("POST", url.getPath());
            httppost.setEntity((HttpEntity)entity);
            request = httppost;
        } else if ("PUT".equals(this.config.getMethod())) {
            BasicClassicHttpRequest httpput = new BasicClassicHttpRequest("PUT", url.getPath());
            httpput.setEntity((HttpEntity)entity);
            request = httpput;
        } else {
            String path = url.getPath();
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                path = path + "?" + url.getQuery();
            } else if (path.trim().length() == 0) {
                path = "/";
            }
            request = new BasicClassicHttpRequest(this.config.getMethod(), path);
        }
        request.setVersion((ProtocolVersion)(this.config.isUseHttp1_0() ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1));
        if (!this.config.isKeepAlive()) {
            request.addHeader((Header)new DefaultHeader("Connection", "close"));
        }
        if ((headers = this.config.getHeaders()) != null) {
            for (String s : headers) {
                int pos = s.indexOf(58);
                if (pos == -1) continue;
                DefaultHeader header = new DefaultHeader(s.substring(0, pos).trim(), s.substring(pos + 1));
                request.addHeader((Header)header);
            }
        }
        if (this.config.isUseAcceptGZip()) {
            request.addHeader((Header)new DefaultHeader("Accept-Encoding", "gzip"));
        }
        if (this.config.getSoapAction() != null && this.config.getSoapAction().length() > 0) {
            request.addHeader((Header)new DefaultHeader("SOAPAction", this.config.getSoapAction()));
        }
        request.setScheme(host.getSchemeName());
        request.setAuthority(new URIAuthority((NamedEndpoint)host));
        return request;
    }

    public String execute() throws Exception {
        Results results = this.doExecute();
        ResultProcessor.printResults(results);
        return "";
    }

    public Results doExecute() throws Exception {
        URL url = this.config.getUrl();
        long endTime = System.currentTimeMillis() + (long)(this.config.getTimeLimit() * 1000);
        HttpHost host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        ThreadPoolExecutor workerPool = new ThreadPoolExecutor(this.config.getThreads(), this.config.getThreads(), 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ClientPool");
            }
        });
        workerPool.prestartAllCoreThreads();
        SSLSocketFactory socketFactory = null;
        if ("https".equals(host.getSchemeName())) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.setProtocol("SSL");
            if (this.config.isDisableSSLVerification()) {
                sslContextBuilder.loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
            } else if (this.config.getTrustStorePath() != null) {
                sslContextBuilder.loadTrustMaterial(new File(this.config.getTrustStorePath()), this.config.getTrustStorePassword() != null ? this.config.getTrustStorePassword().toCharArray() : null);
            }
            if (this.config.getIdentityStorePath() != null) {
                sslContextBuilder.loadKeyMaterial(new File(this.config.getIdentityStorePath()), this.config.getIdentityStorePassword() != null ? this.config.getIdentityStorePassword().toCharArray() : null, this.config.getIdentityStorePassword() != null ? this.config.getIdentityStorePassword().toCharArray() : null);
            }
            SSLContext sslContext = sslContextBuilder.build();
            socketFactory = sslContext.getSocketFactory();
        }
        BenchmarkWorker[] workers = new BenchmarkWorker[this.config.getThreads()];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new BenchmarkWorker(host, this.createRequest(host), socketFactory, this.config);
            workerPool.execute(workers[i]);
        }
        while (workerPool.getCompletedTaskCount() < (long)this.config.getThreads()) {
            Thread.yield();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (this.config.getTimeLimit() == -1 || System.currentTimeMillis() <= endTime) continue;
            for (int i = 0; i < workers.length; ++i) {
                workers[i].setShutdownSignal();
            }
        }
        workerPool.shutdown();
        return ResultProcessor.collectResults(workers, host, this.config.getUrl().toString());
    }
}

