/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLBuffer;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.ReflectionSupport;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SSLIOSession
implements IOSession {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final NamedEndpoint targetEndpoint;
    private final IOSession session;
    private final SSLEngine sslEngine;
    private final SSLBuffer inEncrypted;
    private final SSLBuffer outEncrypted;
    private final SSLBuffer inPlain;
    private final ByteChannel channel;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;
    private final Callback<SSLIOSession> callback;
    private int appEventMask;
    private boolean endOfStream;
    private volatile SSLMode sslMode;
    private volatile int status;
    private volatile boolean initialized;
    private TlsDetails tlsDetails;

    public SSLIOSession(NamedEndpoint targetEndpoint, IOSession session, SSLMode sslMode, SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Callback<SSLIOSession> callback) {
        this(targetEndpoint, session, sslMode, sslContext, SSLBufferManagement.STATIC, initializer, verifier, callback);
    }

    public SSLIOSession(NamedEndpoint targetEndpoint, IOSession session, SSLMode sslMode, SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Callback<SSLIOSession> callback) {
        Args.notNull(session, "IO session");
        Args.notNull(sslContext, "SSL context");
        this.targetEndpoint = targetEndpoint;
        this.session = session;
        this.sslMode = sslMode;
        this.initializer = initializer;
        this.verifier = verifier;
        this.callback = callback;
        this.appEventMask = session.getEventMask();
        this.sslEngine = this.sslMode == SSLMode.CLIENT && targetEndpoint != null ? sslContext.createSSLEngine(targetEndpoint.getHostName(), targetEndpoint.getPort()) : sslContext.createSSLEngine();
        SSLSession sslSession = this.sslEngine.getSession();
        int netBufferSize = sslSession.getPacketBufferSize();
        this.inEncrypted = SSLBufferManagement.create(sslBufferManagement, netBufferSize);
        this.outEncrypted = SSLBufferManagement.create(sslBufferManagement, netBufferSize);
        int appBufferSize = sslSession.getApplicationBufferSize();
        this.inPlain = SSLBufferManagement.create(sslBufferManagement, appBufferSize);
        this.channel = new ByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return SSLIOSession.this.writePlain(src);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return SSLIOSession.this.readPlain(dst);
            }

            @Override
            public void close() throws IOException {
                SSLIOSession.this.close();
            }

            @Override
            public boolean isOpen() {
                return !SSLIOSession.this.isClosed();
            }
        };
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() throws SSLException {
        Asserts.check(!this.initialized, "SSL I/O session already initialized");
        if (this.status >= 1) {
            return;
        }
        switch (this.sslMode) {
            case CLIENT: {
                this.sslEngine.setUseClientMode(true);
                break;
            }
            case SERVER: {
                this.sslEngine.setUseClientMode(false);
            }
        }
        if (this.initializer != null) {
            this.initializer.initialize(this.targetEndpoint, this.sslEngine);
        }
        this.initialized = true;
        this.sslEngine.beginHandshake();
        this.inEncrypted.release();
        this.outEncrypted.release();
        this.inPlain.release();
        this.doHandshake();
    }

    public synchronized TlsDetails getTlsDetails() {
        return this.tlsDetails;
    }

    private SSLException convert(RuntimeException ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            cause = ex;
        }
        return new SSLException(cause);
    }

    private SSLEngineResult doWrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            return this.sslEngine.wrap(src, dst);
        }
        catch (RuntimeException ex) {
            throw this.convert(ex);
        }
    }

    private SSLEngineResult doUnwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            return this.sslEngine.unwrap(src, dst);
        }
        catch (RuntimeException ex) {
            throw this.convert(ex);
        }
    }

    private void doRunTask() throws SSLException {
        try {
            Runnable r = this.sslEngine.getDelegatedTask();
            if (r != null) {
                r.run();
            }
        }
        catch (RuntimeException ex) {
            throw this.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandshake() throws SSLException {
        boolean handshaking = true;
        SSLEngineResult result = null;
        while (handshaking) {
            switch (this.sslEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    ByteBuffer outEncryptedBuf = this.outEncrypted.acquire();
                    result = this.doWrap(EMPTY_BUFFER, outEncryptedBuf);
                    if (result.getStatus() == SSLEngineResult.Status.OK) break;
                    handshaking = false;
                    break;
                }
                case NEED_UNWRAP: {
                    ByteBuffer inEncryptedBuf = this.inEncrypted.acquire();
                    ByteBuffer inPlainBuf = this.inPlain.acquire();
                    inEncryptedBuf.flip();
                    result = this.doUnwrap(inEncryptedBuf, inPlainBuf);
                    inEncryptedBuf.compact();
                    try {
                        if (!inEncryptedBuf.hasRemaining() && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            throw new SSLException("Input buffer is full");
                        }
                    }
                    finally {
                        if (inEncryptedBuf.position() == 0) {
                            this.inEncrypted.release();
                        }
                    }
                    if (this.status >= 1) {
                        this.inPlain.release();
                    }
                    if (result.getStatus() == SSLEngineResult.Status.OK) break;
                    handshaking = false;
                    break;
                }
                case NEED_TASK: {
                    this.doRunTask();
                    break;
                }
                case NOT_HANDSHAKING: {
                    handshaking = false;
                    break;
                }
            }
        }
        if (result != null && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.verifier != null) {
                this.tlsDetails = this.verifier.verify(this.targetEndpoint, this.sslEngine);
            }
            if (this.tlsDetails == null) {
                SSLSession sslSession = this.sslEngine.getSession();
                String applicationProtocol = ReflectionSupport.callGetter(this.sslEngine, "ApplicationProtocol", String.class);
                this.tlsDetails = new TlsDetails(sslSession, applicationProtocol);
            }
            if (this.callback != null) {
                this.callback.execute(this);
            }
        }
    }

    private void updateEventMask() {
        int oldMask;
        if (this.status == 1 && !this.outEncrypted.hasData()) {
            this.sslEngine.closeOutbound();
        }
        if (this.status == 1 && this.sslEngine.isOutboundDone() && (this.endOfStream || this.sslEngine.isInboundDone())) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == 0 && this.endOfStream && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == Integer.MAX_VALUE) {
            this.session.close();
            return;
        }
        int newMask = oldMask = this.session.getEventMask();
        switch (this.sslEngine.getHandshakeStatus()) {
            case NEED_WRAP: {
                newMask = 5;
                break;
            }
            case NEED_UNWRAP: {
                newMask = 1;
                break;
            }
            case NOT_HANDSHAKING: {
                newMask = this.appEventMask;
                break;
            }
            case NEED_TASK: {
                break;
            }
        }
        if (this.outEncrypted.hasData()) {
            newMask |= 4;
        }
        if (oldMask != newMask) {
            this.session.setEventMask(newMask);
        }
    }

    private int sendEncryptedData() throws IOException {
        if (!this.outEncrypted.hasData()) {
            return this.session.channel().write(EMPTY_BUFFER);
        }
        ByteBuffer outEncryptedBuf = this.outEncrypted.acquire();
        int bytesWritten = 0;
        if (outEncryptedBuf.position() > 0) {
            outEncryptedBuf.flip();
            bytesWritten = this.session.channel().write(outEncryptedBuf);
            outEncryptedBuf.compact();
        }
        if (outEncryptedBuf.position() == 0) {
            this.outEncrypted.release();
        }
        return bytesWritten;
    }

    private int receiveEncryptedData() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        ByteBuffer inEncryptedBuf = this.inEncrypted.acquire();
        int ret = this.session.channel().read(inEncryptedBuf);
        if (inEncryptedBuf.position() == 0) {
            this.inEncrypted.release();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decryptData() throws SSLException {
        boolean decrypted = false;
        while (this.inEncrypted.hasData()) {
            ByteBuffer inEncryptedBuf = this.inEncrypted.acquire();
            ByteBuffer inPlainBuf = this.inPlain.acquire();
            inEncryptedBuf.flip();
            SSLEngineResult result = this.doUnwrap(inEncryptedBuf, inPlainBuf);
            inEncryptedBuf.compact();
            try {
                if (!inEncryptedBuf.hasRemaining() && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException("Unable to complete SSL handshake");
                }
                SSLEngineResult.Status status = result.getStatus();
                if (status != SSLEngineResult.Status.OK) {
                    if (status != SSLEngineResult.Status.BUFFER_UNDERFLOW || !this.endOfStream) break;
                    throw new SSLException("Unable to decrypt incoming data due to unexpected end of stream");
                }
                decrypted = true;
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                break;
            }
            finally {
                if (this.inEncrypted.acquire().position() != 0) continue;
                this.inEncrypted.release();
            }
        }
        return decrypted;
    }

    public synchronized boolean isAppInputReady() throws IOException {
        do {
            int bytesRead;
            if ((bytesRead = this.receiveEncryptedData()) == -1) {
                this.endOfStream = true;
            }
            this.doHandshake();
            SSLEngineResult.HandshakeStatus status = this.sslEngine.getHandshakeStatus();
            if (status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && status != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.decryptData();
        } while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK);
        return this.inPlain.hasData() || this.endOfStream && this.status == 0;
    }

    public synchronized boolean isAppOutputReady() throws IOException {
        return (this.appEventMask & 4) > 0 && this.status == 0 && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public synchronized void inboundTransport() throws IOException {
        this.updateEventMask();
    }

    public synchronized void outboundTransport() throws IOException {
        if (this.session.isClosed()) {
            return;
        }
        this.sendEncryptedData();
        this.doHandshake();
        this.updateEventMask();
    }

    public synchronized boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    public synchronized boolean isOutboundDone() {
        return this.sslEngine.isOutboundDone();
    }

    private synchronized int writePlain(ByteBuffer src) throws IOException {
        Args.notNull(src, "Byte buffer");
        if (this.status != 0) {
            throw new ClosedChannelException();
        }
        ByteBuffer outEncryptedBuf = this.outEncrypted.acquire();
        SSLEngineResult result = this.doWrap(src, outEncryptedBuf);
        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.status = Integer.MAX_VALUE;
        }
        return result.bytesConsumed();
    }

    private synchronized int readPlain(ByteBuffer dst) {
        Args.notNull(dst, "Byte buffer");
        if (this.inPlain.hasData()) {
            ByteBuffer inPlainBuf = this.inPlain.acquire();
            inPlainBuf.flip();
            int n = Math.min(inPlainBuf.remaining(), dst.remaining());
            for (int i = 0; i < n; ++i) {
                dst.put(inPlainBuf.get());
            }
            inPlainBuf.compact();
            if (inPlainBuf.position() == 0) {
                this.inPlain.release();
            }
            return n;
        }
        if (this.endOfStream) {
            return -1;
        }
        return 0;
    }

    public synchronized boolean hasInputDate() {
        return this.inPlain.hasData();
    }

    @Override
    public synchronized void close() {
        if (this.status >= 1) {
            return;
        }
        this.status = 1;
        if (this.session.getSocketTimeout() == 0) {
            this.session.setSocketTimeout(1000);
        }
        try {
            this.updateEventMask();
        }
        catch (CancelledKeyException ex) {
            this.shutdown(ShutdownType.GRACEFUL);
        }
    }

    @Override
    public synchronized void shutdown(ShutdownType shutdownType) {
        if (this.status == Integer.MAX_VALUE) {
            return;
        }
        this.inEncrypted.release();
        this.outEncrypted.release();
        this.inPlain.release();
        this.status = Integer.MAX_VALUE;
        this.session.shutdown(shutdownType);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isClosed() {
        return this.status >= 1 || this.session.isClosed();
    }

    @Override
    public synchronized void addLast(Command command) {
        this.session.addLast(command);
        this.setEvent(4);
    }

    @Override
    public synchronized void addFirst(Command command) {
        this.session.addFirst(command);
        this.setEvent(4);
    }

    @Override
    public Command getCommand() {
        return this.session.getCommand();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public synchronized int getEventMask() {
        return this.appEventMask;
    }

    @Override
    public synchronized void setEventMask(int ops) {
        this.appEventMask = ops;
        this.updateEventMask();
    }

    @Override
    public synchronized void setEvent(int op) {
        this.appEventMask |= op;
        this.updateEventMask();
    }

    @Override
    public synchronized void clearEvent(int op) {
        this.appEventMask &= ~op;
        this.updateEventMask();
    }

    @Override
    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.session.setSocketTimeout(timeout);
    }

    @Override
    public IOEventHandler getHandler() {
        return this.session.getHandler();
    }

    @Override
    public void setHandler(IOEventHandler handler) {
        this.session.setHandler(handler);
    }

    private static void formatOps(StringBuilder buffer, int ops) {
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.session);
        buffer.append("[");
        switch (this.status) {
            case 0: {
                buffer.append("ACTIVE");
                break;
            }
            case 1: {
                buffer.append("CLOSING");
                break;
            }
            case 0x7FFFFFFF: {
                buffer.append("CLOSED");
            }
        }
        buffer.append("][");
        SSLIOSession.formatOps(buffer, this.appEventMask);
        buffer.append("][");
        buffer.append((Object)this.sslEngine.getHandshakeStatus());
        if (this.sslEngine.isInboundDone()) {
            buffer.append("][inbound done][");
        }
        if (this.sslEngine.isOutboundDone()) {
            buffer.append("][outbound done][");
        }
        if (this.endOfStream) {
            buffer.append("][EOF][");
        }
        buffer.append("][");
        buffer.append(!this.inEncrypted.hasData() ? 0 : this.inEncrypted.acquire().position());
        buffer.append("][");
        buffer.append(!this.inPlain.hasData() ? 0 : this.inPlain.acquire().position());
        buffer.append("][");
        buffer.append(!this.outEncrypted.hasData() ? 0 : this.outEncrypted.acquire().position());
        buffer.append("]");
        return buffer.toString();
    }
}

