/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLIOSession;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Asserts;

final class InternalDataChannel
extends InternalChannel
implements TlsCapableIOSession {
    private final IOSession ioSession;
    private final NamedEndpoint namedEndpoint;
    private final IOSessionListener sessionListener;
    private final AtomicReference<SSLIOSession> tlsSessionRef;
    private final Queue<InternalDataChannel> closedSessions;
    private final AtomicBoolean connected;
    private final AtomicBoolean closed;

    InternalDataChannel(IOSession ioSession, NamedEndpoint namedEndpoint, IOSessionListener sessionListener, Queue<InternalDataChannel> closedSessions) {
        this.ioSession = ioSession;
        this.namedEndpoint = namedEndpoint;
        this.closedSessions = closedSessions;
        this.sessionListener = sessionListener;
        this.tlsSessionRef = new AtomicReference<Object>(null);
        this.connected = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    private IOSession getSessionImpl() {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null) {
            return tlsSession;
        }
        return this.ioSession;
    }

    private IOEventHandler getEventHandler() {
        IOEventHandler handler = this.ioSession.getHandler();
        Asserts.notNull(handler, "IO event handler");
        return handler;
    }

    @Override
    void onIOEvent(int readyOps) throws IOException {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null) {
            IOEventHandler handler;
            if (!tlsSession.isInitialized()) {
                tlsSession.initialize();
                if (this.sessionListener != null) {
                    this.sessionListener.tlsStarted(tlsSession);
                }
            }
            if ((readyOps & 8) != 0) {
                this.ioSession.clearEvent(8);
            }
            if ((readyOps & 1) != 0) {
                if (tlsSession.isAppInputReady()) {
                    do {
                        if (this.sessionListener != null) {
                            this.sessionListener.inputReady(this);
                        }
                        handler = this.getEventHandler();
                        handler.inputReady(this);
                    } while (tlsSession.hasInputDate());
                }
                tlsSession.inboundTransport();
                if (this.sessionListener != null) {
                    this.sessionListener.tlsInbound(tlsSession);
                }
            }
            if ((readyOps & 4) != 0) {
                if (tlsSession.isAppOutputReady()) {
                    if (this.sessionListener != null) {
                        this.sessionListener.outputReady(this);
                    }
                    handler = this.getEventHandler();
                    handler.outputReady(this);
                }
                tlsSession.outboundTransport();
                if (this.sessionListener != null) {
                    this.sessionListener.tlsOutbound(tlsSession);
                }
            }
        } else {
            IOEventHandler handler;
            if ((readyOps & 8) != 0) {
                this.ioSession.clearEvent(8);
                if (this.connected.compareAndSet(false, true)) {
                    if (this.sessionListener != null) {
                        this.sessionListener.connected(this);
                    }
                    handler = this.getEventHandler();
                    handler.connected(this);
                }
            }
            if ((readyOps & 1) != 0) {
                if (this.sessionListener != null) {
                    this.sessionListener.inputReady(this);
                }
                handler = this.getEventHandler();
                handler.inputReady(this);
            }
            if ((readyOps & 4) != 0) {
                if (this.sessionListener != null) {
                    this.sessionListener.outputReady(this);
                }
                handler = this.getEventHandler();
                handler.outputReady(this);
            }
        }
    }

    @Override
    int getTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    void onTimeout() throws IOException {
        IOEventHandler handler = this.getEventHandler();
        handler.timeout(this);
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null && tlsSession.isOutboundDone() && !tlsSession.isInboundDone()) {
            tlsSession.shutdown(ShutdownType.IMMEDIATE);
        }
    }

    @Override
    void onException(Exception cause) {
        IOEventHandler handler = this.getEventHandler();
        if (this.sessionListener != null) {
            this.sessionListener.exception(this, cause);
        }
        handler.exception(this, cause);
    }

    void disconnected() {
        if (this.sessionListener != null) {
            this.sessionListener.disconnected(this);
        }
        IOEventHandler handler = this.getEventHandler();
        handler.disconnected(this);
    }

    @Override
    public void startTls(SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        if (!this.tlsSessionRef.compareAndSet(null, new SSLIOSession(this.namedEndpoint, this.ioSession, this.namedEndpoint != null ? SSLMode.CLIENT : SSLMode.SERVER, sslContext, sslBufferManagement, initializer, verifier, new Callback<SSLIOSession>(){

            @Override
            public void execute(SSLIOSession sslSession) {
                if (InternalDataChannel.this.connected.compareAndSet(false, true)) {
                    IOEventHandler handler = InternalDataChannel.this.getEventHandler();
                    try {
                        if (InternalDataChannel.this.sessionListener != null) {
                            InternalDataChannel.this.sessionListener.connected(InternalDataChannel.this);
                        }
                        handler.connected(InternalDataChannel.this);
                    }
                    catch (Exception ex) {
                        if (InternalDataChannel.this.sessionListener != null) {
                            InternalDataChannel.this.sessionListener.exception(InternalDataChannel.this, ex);
                        }
                        handler.exception(InternalDataChannel.this, ex);
                    }
                }
            }
        }))) {
            throw new IllegalStateException("TLS already activated");
        }
    }

    @Override
    public TlsDetails getTlsDetails() {
        SSLIOSession sslIoSession = this.tlsSessionRef.get();
        return sslIoSession != null ? sslIoSession.getTlsDetails() : null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().close();
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().shutdown(shutdownType);
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    @Override
    public int getStatus() {
        return this.getSessionImpl().getStatus();
    }

    @Override
    public boolean isClosed() {
        return this.getSessionImpl().isClosed();
    }

    @Override
    public IOEventHandler getHandler() {
        return this.ioSession.getHandler();
    }

    @Override
    public void setHandler(IOEventHandler eventHandler) {
        this.ioSession.setHandler(eventHandler);
    }

    @Override
    public void addLast(Command command) {
        this.getSessionImpl().addLast(command);
    }

    @Override
    public void addFirst(Command command) {
        this.getSessionImpl().addFirst(command);
    }

    @Override
    public Command getCommand() {
        return this.getSessionImpl().getCommand();
    }

    @Override
    public ByteChannel channel() {
        return this.getSessionImpl().channel();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public int getEventMask() {
        return this.getSessionImpl().getEventMask();
    }

    @Override
    public void setEventMask(int ops) {
        this.getSessionImpl().setEventMask(ops);
    }

    @Override
    public void setEvent(int op) {
        this.getSessionImpl().setEvent(op);
    }

    @Override
    public void clearEvent(int op) {
        this.getSessionImpl().clearEvent(op);
    }

    @Override
    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public String toString() {
        return this.getSessionImpl().toString();
    }
}

