/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.AbstractHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

class AbstractHttp1IOEventHandler
implements HttpConnectionEventHandler {
    private final AbstractHttp1StreamDuplexer<?, ?> streamDuplexer;

    AbstractHttp1IOEventHandler(AbstractHttp1StreamDuplexer<?, ?> streamDuplexer) {
        this.streamDuplexer = Args.notNull(streamDuplexer, "Stream multiplexer");
    }

    @Override
    public void connected(IOSession session) throws IOException {
        try {
            this.streamDuplexer.onConnect(null);
        }
        catch (HttpException ex) {
            this.streamDuplexer.onException(ex);
        }
    }

    @Override
    public void inputReady(IOSession session) throws IOException {
        try {
            this.streamDuplexer.onInput();
        }
        catch (HttpException ex) {
            this.streamDuplexer.onException(ex);
        }
    }

    @Override
    public void outputReady(IOSession session) throws IOException {
        try {
            this.streamDuplexer.onOutput();
        }
        catch (HttpException ex) {
            this.streamDuplexer.onException(ex);
        }
    }

    @Override
    public void timeout(IOSession session) throws IOException {
        try {
            this.streamDuplexer.onTimeout();
        }
        catch (HttpException ex) {
            this.streamDuplexer.onException(ex);
        }
    }

    @Override
    public void exception(IOSession session, Exception cause) {
        this.streamDuplexer.onException(cause);
    }

    @Override
    public void disconnected(IOSession session) {
        this.streamDuplexer.onDisconnect();
    }

    @Override
    public void close() throws IOException {
        this.streamDuplexer.close();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.streamDuplexer.shutdown(shutdownType);
    }

    @Override
    public boolean isOpen() {
        return this.streamDuplexer.isOpen();
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.streamDuplexer.setSocketTimeout(timeout);
    }

    @Override
    public SSLSession getSSLSession() {
        return this.streamDuplexer.getSSLSession();
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return this.streamDuplexer.getEndpointDetails();
    }

    @Override
    public int getSocketTimeout() {
        return this.streamDuplexer.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.streamDuplexer.getProtocolVersion();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.streamDuplexer.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.streamDuplexer.getLocalAddress();
    }

    public String toString() {
        return this.streamDuplexer.toString();
    }
}

