/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.AbstractSingleCoreIOReactor;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionImpl;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.IOSessionRequest;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.InternalConnectChannel;
import org.apache.hc.core5.reactor.InternalDataChannel;
import org.apache.hc.core5.reactor.InternalDataChannelFactory;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

class SingleCoreIOReactor
extends AbstractSingleCoreIOReactor
implements ConnectionInitiator {
    private final IOEventHandlerFactory eventHandlerFactory;
    private final IOReactorConfig reactorConfig;
    private final Decorator<IOSession> ioSessionDecorator;
    private final IOSessionListener sessionListener;
    private final Callback<IOSession> sessionShutdownCallback;
    private final Queue<InternalDataChannel> closedSessions;
    private final Queue<SocketChannel> channelQueue;
    private final Queue<IOSessionRequest> requestQueue;
    private final AtomicBoolean shutdownInitiated;
    private volatile long lastTimeoutCheck;

    SingleCoreIOReactor(Queue<ExceptionEvent> auditLog, IOEventHandlerFactory eventHandlerFactory, IOReactorConfig reactorConfig, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        super(auditLog);
        this.eventHandlerFactory = Args.notNull(eventHandlerFactory, "Event handler factory");
        this.reactorConfig = Args.notNull(reactorConfig, "I/O reactor config");
        this.ioSessionDecorator = ioSessionDecorator;
        this.sessionListener = sessionListener;
        this.sessionShutdownCallback = sessionShutdownCallback;
        this.shutdownInitiated = new AtomicBoolean(false);
        this.closedSessions = new ConcurrentLinkedQueue<InternalDataChannel>();
        this.channelQueue = new ConcurrentLinkedQueue<SocketChannel>();
        this.requestQueue = new ConcurrentLinkedQueue<IOSessionRequest>();
    }

    void enqueueChannel(SocketChannel socketChannel) throws IOReactorShutdownException {
        Args.notNull(socketChannel, "SocketChannel");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        this.channelQueue.add(socketChannel);
        this.selector.wakeup();
    }

    @Override
    void doTerminate() {
        this.closePendingChannels();
        this.closePendingConnectionRequests();
        this.processClosedSessions();
    }

    @Override
    void doExecute() throws IOException {
        long selectTimeout = this.reactorConfig.getSelectInterval();
        while (!Thread.currentThread().isInterrupted()) {
            int readyCount = this.selector.select(selectTimeout);
            if (this.getStatus().compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
                if (this.shutdownInitiated.compareAndSet(false, true)) {
                    this.initiateSessionShutdown();
                }
                this.closePendingChannels();
            }
            if (this.getStatus().compareTo(IOReactorStatus.SHUT_DOWN) == 0) break;
            if (readyCount > 0) {
                this.processEvents(this.selector.selectedKeys());
            }
            this.validateActiveChannels();
            this.processClosedSessions();
            if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) == 0) {
                this.processPendingChannels();
                this.processPendingConnectionRequests();
            }
            if ((this.getStatus().compareTo(IOReactorStatus.SHUTTING_DOWN) != 0 || !this.selector.keys().isEmpty()) && this.getStatus().compareTo(IOReactorStatus.SHUT_DOWN) != 0) continue;
            break;
        }
    }

    private void initiateSessionShutdown() {
        if (this.sessionShutdownCallback != null) {
            Set<SelectionKey> keys = this.selector.keys();
            for (SelectionKey key : keys) {
                InternalChannel channel = (InternalChannel)key.attachment();
                if (!(channel instanceof InternalDataChannel)) continue;
                this.sessionShutdownCallback.execute((InternalDataChannel)channel);
            }
        }
    }

    private void validateActiveChannels() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.reactorConfig.getSelectInterval()) {
            this.lastTimeoutCheck = currentTime;
            for (SelectionKey key : this.selector.keys()) {
                this.timeoutCheck(key, currentTime);
            }
        }
    }

    private void processEvents(Set<SelectionKey> selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            InternalChannel channel = (InternalChannel)key.attachment();
            try {
                channel.handleIOEvent(key.readyOps());
            }
            catch (CancelledKeyException ex) {
                channel.shutdown(ShutdownType.GRACEFUL);
            }
        }
        selectedKeys.clear();
    }

    private void processPendingChannels() throws IOException {
        SocketChannel socketChannel;
        while ((socketChannel = this.channelQueue.poll()) != null) {
            SelectionKey key;
            try {
                this.prepareSocket(socketChannel.socket());
                socketChannel.configureBlocking(false);
            }
            catch (IOException ex) {
                this.addExceptionEvent(ex);
                try {
                    socketChannel.close();
                }
                catch (IOException ex2) {
                    this.addExceptionEvent(ex2);
                }
                throw ex;
            }
            try {
                key = socketChannel.register(this.selector, 1);
            }
            catch (ClosedChannelException ex) {
                return;
            }
            IOSession ioSession = new IOSessionImpl(key, socketChannel);
            if (this.ioSessionDecorator != null) {
                ioSession = this.ioSessionDecorator.decorate(ioSession);
            }
            InternalDataChannel dataChannel = new InternalDataChannel(ioSession, null, this.sessionListener, this.closedSessions);
            dataChannel.setHandler(this.eventHandlerFactory.createHandler(dataChannel, null));
            dataChannel.setSocketTimeout(this.reactorConfig.getSoTimeout().toMillisIntBound());
            key.attach(dataChannel);
            dataChannel.handleIOEvent(8);
        }
    }

    private void processClosedSessions() {
        InternalDataChannel dataChannel;
        while ((dataChannel = this.closedSessions.poll()) != null) {
            try {
                dataChannel.disconnected();
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
    }

    private void timeoutCheck(SelectionKey key, long now) {
        InternalChannel channel = (InternalChannel)key.attachment();
        if (channel != null) {
            channel.checkTimeout(now);
        }
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, TimeValue timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        IOSessionRequest sessionRequest = new IOSessionRequest(remoteEndpoint, remoteAddress != null ? remoteAddress : new InetSocketAddress(remoteEndpoint.getHostName(), remoteEndpoint.getPort()), localAddress, timeout, attachment, callback);
        this.requestQueue.add(sessionRequest);
        this.selector.wakeup();
        return sessionRequest;
    }

    private void prepareSocket(Socket socket) throws IOException {
        int linger;
        socket.setTcpNoDelay(this.reactorConfig.isTcpNoDelay());
        socket.setKeepAlive(this.reactorConfig.isSoKeepalive());
        if (this.reactorConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.reactorConfig.getSndBufSize());
        }
        if (this.reactorConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.reactorConfig.getRcvBufSize());
        }
        if ((linger = this.reactorConfig.getSoLinger().toSecondsIntBound()) >= 0) {
            socket.setSoLinger(true, linger);
        }
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processPendingConnectionRequests() {
        IOSessionRequest sessionRequest;
        while ((sessionRequest = this.requestQueue.poll()) != null) {
            SocketChannel socketChannel;
            if (sessionRequest.isCancelled()) continue;
            try {
                socketChannel = SocketChannel.open();
            }
            catch (IOException ex) {
                sessionRequest.failed(ex);
                return;
            }
            try {
                this.processConnectionRequest(socketChannel, sessionRequest);
            }
            catch (IOException ex) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sessionRequest.failed(ex);
            }
        }
    }

    private void processConnectionRequest(SocketChannel socketChannel, IOSessionRequest sessionRequest) throws IOException {
        this.validateAddress(sessionRequest.localAddress);
        this.validateAddress(sessionRequest.remoteAddress);
        socketChannel.configureBlocking(false);
        this.prepareSocket(socketChannel.socket());
        if (sessionRequest.localAddress != null) {
            Socket sock = socketChannel.socket();
            sock.setReuseAddress(this.reactorConfig.isSoReuseAddress());
            sock.bind(sessionRequest.localAddress);
        }
        boolean connected = socketChannel.connect(sessionRequest.remoteAddress);
        SelectionKey key = socketChannel.register(this.selector, 9);
        InternalConnectChannel channel = new InternalConnectChannel(key, socketChannel, sessionRequest, new InternalDataChannelFactory(){

            @Override
            public InternalDataChannel create(SelectionKey key, SocketChannel socketChannel, NamedEndpoint namedEndpoint, Object attachment) {
                IOSession ioSession = new IOSessionImpl(key, socketChannel);
                if (SingleCoreIOReactor.this.ioSessionDecorator != null) {
                    ioSession = SingleCoreIOReactor.this.ioSessionDecorator.decorate(ioSession);
                }
                InternalDataChannel dataChannel = new InternalDataChannel(ioSession, namedEndpoint, SingleCoreIOReactor.this.sessionListener, SingleCoreIOReactor.this.closedSessions);
                dataChannel.setHandler(SingleCoreIOReactor.this.eventHandlerFactory.createHandler(dataChannel, attachment));
                dataChannel.setSocketTimeout(SingleCoreIOReactor.this.reactorConfig.getSoTimeout().toMillisIntBound());
                return dataChannel;
            }
        });
        if (connected) {
            channel.handleIOEvent(8);
        } else {
            key.attach(channel);
            sessionRequest.assign(channel);
        }
    }

    private void closePendingChannels() {
        SocketChannel socketChannel;
        while ((socketChannel = this.channelQueue.poll()) != null) {
            try {
                socketChannel.close();
            }
            catch (IOException ex) {
                this.addExceptionEvent(ex);
            }
        }
    }

    private void closePendingConnectionRequests() {
        IOSessionRequest sessionRequest;
        while ((sessionRequest = this.requestQueue.poll()) != null) {
            sessionRequest.cancel();
        }
    }
}

