/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.IOSessionRequest;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.InternalDataChannel;
import org.apache.hc.core5.reactor.InternalDataChannelFactory;

final class InternalConnectChannel
extends InternalChannel {
    private final SelectionKey key;
    private final SocketChannel socketChannel;
    private final IOSessionRequest sessionRequest;
    private final InternalDataChannelFactory dataChannelFactory;

    InternalConnectChannel(SelectionKey key, SocketChannel socketChannel, IOSessionRequest sessionRequest, InternalDataChannelFactory dataChannelFactory) {
        this.key = key;
        this.socketChannel = socketChannel;
        this.sessionRequest = sessionRequest;
        this.dataChannelFactory = dataChannelFactory;
    }

    @Override
    void onIOEvent(int readyOps) throws IOException {
        if ((readyOps & 8) != 0) {
            if (this.socketChannel.isConnectionPending()) {
                this.socketChannel.finishConnect();
            }
            InternalDataChannel dataChannel = this.dataChannelFactory.create(this.key, this.socketChannel, this.sessionRequest.remoteEndpoint, this.sessionRequest.attachment);
            this.key.attach(dataChannel);
            this.sessionRequest.completed(dataChannel);
            dataChannel.handleIOEvent(8);
        }
    }

    @Override
    int getTimeout() {
        return this.sessionRequest.timeout.toMillisIntBound();
    }

    @Override
    void onTimeout() throws IOException {
        this.sessionRequest.failed(new SocketTimeoutException());
    }

    @Override
    void onException(Exception cause) {
        this.sessionRequest.failed(cause);
    }

    @Override
    public void close() throws IOException {
        this.key.cancel();
        this.socketChannel.close();
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

