/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;

abstract class InternalChannel
implements GracefullyCloseable {
    private volatile long lastEventTime = System.currentTimeMillis();

    InternalChannel() {
    }

    abstract void onIOEvent(int var1) throws IOException;

    abstract void onTimeout() throws IOException;

    abstract void onException(Exception var1);

    abstract int getTimeout();

    final void handleIOEvent(int ops) {
        this.lastEventTime = System.currentTimeMillis();
        try {
            this.onIOEvent(ops);
        }
        catch (CancelledKeyException ex) {
            this.shutdown(ShutdownType.GRACEFUL);
        }
        catch (Exception ex) {
            this.onException(ex);
            this.shutdown(ShutdownType.IMMEDIATE);
        }
    }

    final void checkTimeout(long currentTime) {
        long deadline;
        int timeout = this.getTimeout();
        if (timeout > 0 && currentTime > (deadline = this.lastEventTime + (long)timeout)) {
            try {
                this.onTimeout();
            }
            catch (CancelledKeyException ex) {
                this.shutdown(ShutdownType.GRACEFUL);
            }
            catch (Exception ex) {
                this.onException(ex);
                this.shutdown(ShutdownType.IMMEDIATE);
            }
        }
    }
}

