/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionAcceptor;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorService;
import org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOReactorWorker;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.MultiCoreIOReactor;
import org.apache.hc.core5.reactor.SingleCoreIOReactor;
import org.apache.hc.core5.reactor.SingleCoreListeningIOReactor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class DefaultListeningIOReactor
implements IOReactorService,
ConnectionInitiator,
ConnectionAcceptor {
    private static final ThreadFactory DISPATCH_THREAD_FACTORY = new DefaultThreadFactory("I/O server dispatch", true);
    private static final ThreadFactory LISTENER_THREAD_FACTORY = new DefaultThreadFactory("I/O listener", true);
    private final Deque<ExceptionEvent> auditLog;
    private final int workerCount;
    private final SingleCoreIOReactor[] dispatchers;
    private final SingleCoreListeningIOReactor listener;
    private final MultiCoreIOReactor ioReactor;
    private final AtomicInteger currentWorker;

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory dispatchThreadFactory, ThreadFactory listenerThreadFactory, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        Args.notNull(eventHandlerFactory, "Event handler factory");
        this.auditLog = new ConcurrentLinkedDeque<ExceptionEvent>();
        this.workerCount = ioReactorConfig != null ? ioReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.dispatchers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threads = new Thread[this.workerCount + 1];
        for (int i = 0; i < this.dispatchers.length; ++i) {
            SingleCoreIOReactor dispatcher;
            this.dispatchers[i] = dispatcher = new SingleCoreIOReactor(this.auditLog, eventHandlerFactory, ioReactorConfig, ioSessionDecorator, sessionListener, sessionShutdownCallback);
            threads[i + 1] = (dispatchThreadFactory != null ? dispatchThreadFactory : DISPATCH_THREAD_FACTORY).newThread(new IOReactorWorker(dispatcher));
        }
        IOReactor[] ioReactors = new IOReactor[this.workerCount + 1];
        System.arraycopy(this.dispatchers, 0, ioReactors, 1, this.workerCount);
        this.listener = new SingleCoreListeningIOReactor(this.auditLog, ioReactorConfig, new Callback<SocketChannel>(){

            @Override
            public void execute(SocketChannel channel) {
                DefaultListeningIOReactor.this.enqueueChannel(channel);
            }
        });
        ioReactors[0] = this.listener;
        threads[0] = (listenerThreadFactory != null ? listenerThreadFactory : LISTENER_THREAD_FACTORY).newThread(new IOReactorWorker(this.listener));
        this.ioReactor = new MultiCoreIOReactor(ioReactors, threads);
        this.currentWorker = new AtomicInteger(0);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback) {
        this(eventHandlerFactory, config, null, null, null, null, sessionShutdownCallback);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory) {
        this(eventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public Future<ListenerEndpoint> listen(SocketAddress address, FutureCallback<ListenerEndpoint> callback) {
        return this.listener.listen(address, callback);
    }

    public Future<ListenerEndpoint> listen(SocketAddress address) {
        return this.listen(address, null);
    }

    @Override
    public Set<ListenerEndpoint> getEndpoints() {
        return this.listener.getEndpoints();
    }

    @Override
    public void pause() throws IOException {
        this.listener.pause();
    }

    @Override
    public void resume() throws IOException {
        this.listener.resume();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public List<ExceptionEvent> getExceptionLog() {
        return this.auditLog.isEmpty() ? Collections.emptyList() : new ArrayList<ExceptionEvent>(this.auditLog);
    }

    private void enqueueChannel(SocketChannel socketChannel) {
        int i = Math.abs(this.currentWorker.incrementAndGet() % this.workerCount);
        try {
            this.dispatchers[i].enqueueChannel(socketChannel);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
        }
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, TimeValue timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        int i = Math.abs(this.currentWorker.incrementAndGet() % this.workerCount);
        try {
            return this.dispatchers[i].connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
            throw ex;
        }
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.ioReactor.shutdown(shutdownType);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

