/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorService;
import org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOReactorWorker;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.MultiCoreIOReactor;
import org.apache.hc.core5.reactor.SingleCoreIOReactor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class DefaultConnectingIOReactor
implements IOReactorService,
ConnectionInitiator {
    private final Deque<ExceptionEvent> auditLog;
    private final int workerCount;
    private final SingleCoreIOReactor[] dispatchers;
    private final MultiCoreIOReactor ioReactor;
    private final AtomicInteger currentWorker;
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory("I/O client dispatch", true);

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        Args.notNull(eventHandlerFactory, "Event handler factory");
        this.auditLog = new ConcurrentLinkedDeque<ExceptionEvent>();
        this.workerCount = ioReactorConfig != null ? ioReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.dispatchers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threads = new Thread[this.workerCount];
        for (int i = 0; i < this.dispatchers.length; ++i) {
            SingleCoreIOReactor dispatcher;
            this.dispatchers[i] = dispatcher = new SingleCoreIOReactor(this.auditLog, eventHandlerFactory, ioReactorConfig, ioSessionDecorator, sessionListener, sessionShutdownCallback);
            threads[i] = (threadFactory != null ? threadFactory : THREAD_FACTORY).newThread(new IOReactorWorker(dispatcher));
        }
        this.ioReactor = new MultiCoreIOReactor(this.dispatchers, threads);
        this.currentWorker = new AtomicInteger(0);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback) {
        this(eventHandlerFactory, config, null, null, null, sessionShutdownCallback);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory) {
        this(eventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public List<ExceptionEvent> getExceptionLog() {
        return this.auditLog.isEmpty() ? Collections.emptyList() : new ArrayList<ExceptionEvent>(this.auditLog);
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, TimeValue timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        int i = Math.abs(this.currentWorker.incrementAndGet() % this.workerCount);
        try {
            return this.dispatchers[i].connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
            throw ex;
        }
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.ioReactor.shutdown(shutdownType);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

