/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.util.Args;

public abstract class AbstractCharAsyncEntityProducer
implements AsyncEntityProducer {
    private static final CharBuffer EMPTY = CharBuffer.wrap(new char[0]);
    private final ByteBuffer bytebuf;
    private final int fragmentSizeHint;
    private final ContentType contentType;
    private final CharsetEncoder charsetEncoder;
    private final StreamChannel<CharBuffer> charDataStream;
    private volatile State state;

    public AbstractCharAsyncEntityProducer(int bufferSize, int fragmentSizeHint, ContentType contentType) {
        Charset charset;
        Args.positive(bufferSize, "Buffer size");
        this.fragmentSizeHint = fragmentSizeHint >= 0 ? fragmentSizeHint : bufferSize / 2;
        this.bytebuf = ByteBuffer.allocate(bufferSize);
        this.contentType = contentType;
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = StandardCharsets.US_ASCII;
        }
        this.charsetEncoder = charset.newEncoder();
        this.charDataStream = new StreamChannel<CharBuffer>(){

            @Override
            public int write(CharBuffer src) throws IOException {
                Args.notNull(src, "Buffer");
                int p = src.position();
                CoderResult result = AbstractCharAsyncEntityProducer.this.charsetEncoder.encode(src, AbstractCharAsyncEntityProducer.this.bytebuf, false);
                if (result.isError()) {
                    result.throwException();
                }
                return src.position() - p;
            }

            @Override
            public void endStream() throws IOException {
                AbstractCharAsyncEntityProducer.this.state = State.FLUSHING;
            }
        };
        this.state = State.ACTIVE;
    }

    protected abstract void produceData(StreamChannel<CharBuffer> var1) throws IOException;

    @Override
    public final String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public final void produce(DataStreamChannel channel) throws IOException {
        if (this.state.compareTo(State.ACTIVE) == 0) {
            this.produceData(this.charDataStream);
        }
        if (this.state.compareTo(State.ACTIVE) > 0 || !this.bytebuf.hasRemaining() || this.bytebuf.position() >= this.fragmentSizeHint) {
            this.bytebuf.flip();
            channel.write(this.bytebuf);
            this.bytebuf.compact();
        }
        if (this.state.compareTo(State.FLUSHING) == 0) {
            CoderResult result = this.charsetEncoder.encode(EMPTY, this.bytebuf, true);
            if (result.isError()) {
                result.throwException();
            } else if (result.isUnderflow()) {
                CoderResult result2 = this.charsetEncoder.flush(this.bytebuf);
                if (result2.isError()) {
                    result.throwException();
                } else if (result2.isUnderflow()) {
                    this.state = State.END_STREAM;
                }
            }
        }
        if (this.bytebuf.position() == 0 && this.state.compareTo(State.END_STREAM) == 0) {
            channel.endStream();
        }
    }

    private static enum State {
        ACTIVE,
        FLUSHING,
        END_STREAM;

    }
}

