/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.Args;

public class HttpEntityWithTrailers
implements HttpEntity {
    private final HttpEntity wrappedEntity;
    private final List<Header> trailers;

    public HttpEntityWithTrailers(HttpEntity wrappedEntity, Header ... trailers) {
        this.wrappedEntity = Args.notNull(wrappedEntity, "Wrapped entity");
        this.trailers = Arrays.asList(trailers);
    }

    @Override
    public boolean isRepeatable() {
        return this.wrappedEntity.isRepeatable();
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.wrappedEntity.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.wrappedEntity.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.wrappedEntity.getContentEncoding();
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.wrappedEntity.getContent();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.wrappedEntity.writeTo(outstream);
    }

    @Override
    public boolean isStreaming() {
        return this.wrappedEntity.isStreaming();
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return new Supplier<List<? extends Header>>(){

            @Override
            public List<? extends Header> get() {
                return HttpEntityWithTrailers.this.trailers;
            }
        };
    }

    @Override
    public Set<String> getTrailerNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Header trailer : this.trailers) {
            names.add(trailer.getName());
        }
        return names;
    }

    @Override
    public void close() throws IOException {
        this.wrappedEntity.close();
    }
}

