/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorService;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class AsyncRequester
implements IOReactorService,
ConnectionInitiator {
    private final DefaultConnectingIOReactor ioReactor;

    public AsyncRequester(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        this.ioReactor = new DefaultConnectingIOReactor(eventHandlerFactory, ioReactorConfig, new DefaultThreadFactory("requester-dispatch", true), ioSessionDecorator, sessionListener, sessionShutdownCallback);
    }

    private InetSocketAddress toSocketAddress(HttpHost host) {
        int port = host.getPort();
        if (port < 0) {
            String scheme = host.getSchemeName();
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        String hostName = host.getHostName();
        return new InetSocketAddress(hostName, port);
    }

    @Override
    public Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, TimeValue timeout, Object attachment, FutureCallback<IOSession> callback) {
        return this.ioReactor.connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
    }

    public Future<IOSession> requestSession(HttpHost host, TimeValue timeout, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout, "Timeout");
        return this.connect(host, this.toSocketAddress(host), null, timeout, attachment, callback);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public List<ExceptionEvent> getExceptionLog() {
        return this.ioReactor.getExceptionLog();
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void shutdown(ShutdownType shutdownType) {
        this.ioReactor.shutdown(shutdownType);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

