/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnectionFactory;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.StrictConnPool;
import org.apache.hc.core5.testing.classic.LoggingConnPoolListener;
import org.apache.hc.core5.testing.classic.LoggingHttp1StreamListener;
import org.apache.hc.core5.util.TimeValue;

public class ClassicTestClient {
    private final SSLContext sslContext;
    private final SocketConfig socketConfig;
    private final AtomicReference<HttpRequester> requesterRef;

    public ClassicTestClient(SSLContext sslContext, SocketConfig socketConfig) {
        this.sslContext = sslContext;
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.requesterRef = new AtomicReference<Object>(null);
    }

    public ClassicTestClient(SocketConfig socketConfig) {
        this(null, socketConfig);
    }

    public ClassicTestClient() {
        this(null, null);
    }

    public void start() {
        this.start(null);
    }

    public void start(HttpProcessor httpProcessor) {
        if (this.requesterRef.get() != null) {
            throw new IllegalStateException("Requester has already been started");
        }
        HttpRequestExecutor requestExecutor = new HttpRequestExecutor(3000, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, (Http1StreamListener)LoggingHttp1StreamListener.INSTANCE);
        StrictConnPool connPool = new StrictConnPool(20, 50, TimeValue.NEG_ONE_MILLISECONDS, PoolReusePolicy.LIFO, (ConnPoolListener)LoggingConnPoolListener.INSTANCE);
        HttpRequester requester = new HttpRequester(requestExecutor, httpProcessor != null ? httpProcessor : HttpProcessors.client(), (ManagedConnPool)connPool, this.socketConfig, (HttpConnectionFactory)new DefaultBHttpClientConnectionFactory(H1Config.DEFAULT, CharCodingConfig.DEFAULT), this.sslContext != null ? this.sslContext.getSocketFactory() : null, (Resolver)DefaultAddressResolver.INSTANCE);
        this.requesterRef.compareAndSet(null, requester);
    }

    public void shutdown(CloseMode closeMode) {
        HttpRequester requester = this.requesterRef.getAndSet(null);
        if (requester != null) {
            requester.close(closeMode);
        }
    }

    public ClassicHttpResponse execute(HttpHost targetHost, ClassicHttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpRequester requester = this.requesterRef.get();
        if (requester == null) {
            throw new IllegalStateException("Requester has not been started");
        }
        if (request.getAuthority() == null) {
            request.setAuthority(new URIAuthority((NamedEndpoint)targetHost));
        }
        request.setScheme(targetHost.getSchemeName());
        return requester.execute(targetHost, request, this.socketConfig.getSoTimeout(), context);
    }
}

