/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLIOSession;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

final class InternalDataChannel
extends InternalChannel
implements ProtocolIOSession {
    private final IOSession ioSession;
    private final NamedEndpoint initialEndpoint;
    private final IOSessionListener sessionListener;
    private final AtomicReference<SSLIOSession> tlsSessionRef;
    private final Queue<InternalDataChannel> closedSessions;
    private final AtomicReference<IOEventHandler> handlerRef;
    private final AtomicBoolean connected;
    private final AtomicBoolean closed;

    InternalDataChannel(IOSession ioSession, NamedEndpoint initialEndpoint, IOSessionListener sessionListener, Queue<InternalDataChannel> closedSessions) {
        this.ioSession = ioSession;
        this.initialEndpoint = initialEndpoint;
        this.closedSessions = closedSessions;
        this.sessionListener = sessionListener;
        this.tlsSessionRef = new AtomicReference<Object>(null);
        this.handlerRef = new AtomicReference<Object>(null);
        this.connected = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    @Override
    public IOEventHandler getHandler() {
        return this.handlerRef.get();
    }

    @Override
    public NamedEndpoint getInitialEndpoint() {
        return this.initialEndpoint;
    }

    @Override
    public void upgrade(IOEventHandler handler) {
        this.handlerRef.set(handler);
    }

    private IOEventHandler ensureHandler() {
        IOEventHandler handler = this.handlerRef.get();
        Asserts.notNull(handler, "IO event handler");
        return handler;
    }

    @Override
    void onIOEvent(int readyOps) throws IOException {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null) {
            IOEventHandler handler;
            if (!tlsSession.isInitialized()) {
                tlsSession.initialize();
                if (this.sessionListener != null) {
                    this.sessionListener.tlsStarted(tlsSession);
                }
            }
            if ((readyOps & 8) != 0) {
                tlsSession.clearEvent(8);
            }
            if ((readyOps & 1) != 0) {
                this.ioSession.updateReadTime();
                do {
                    tlsSession.resetReadCount();
                    if (tlsSession.isAppInputReady()) {
                        if (this.sessionListener != null) {
                            this.sessionListener.inputReady(this);
                        }
                        handler = this.ensureHandler();
                        handler.inputReady(this);
                    }
                    tlsSession.inboundTransport();
                    if (this.sessionListener == null) continue;
                    this.sessionListener.tlsInbound(tlsSession);
                } while (tlsSession.getReadCount() > 0L);
            }
            if ((readyOps & 4) != 0 || (this.ioSession.getEventMask() & 4) != 0) {
                this.ioSession.updateWriteTime();
                if (tlsSession.isAppOutputReady()) {
                    if (this.sessionListener != null) {
                        this.sessionListener.outputReady(this);
                    }
                    handler = this.ensureHandler();
                    handler.outputReady(this);
                }
                tlsSession.outboundTransport();
                if (this.sessionListener != null) {
                    this.sessionListener.tlsOutbound(tlsSession);
                }
            }
        } else {
            IOEventHandler handler;
            if ((readyOps & 8) != 0) {
                this.ioSession.clearEvent(8);
                if (this.connected.compareAndSet(false, true)) {
                    if (this.sessionListener != null) {
                        this.sessionListener.connected(this);
                    }
                    handler = this.ensureHandler();
                    handler.connected(this);
                }
            }
            if ((readyOps & 1) != 0) {
                this.ioSession.updateReadTime();
                if (this.sessionListener != null) {
                    this.sessionListener.inputReady(this);
                }
                handler = this.ensureHandler();
                handler.inputReady(this);
            }
            if ((readyOps & 4) != 0) {
                this.ioSession.updateWriteTime();
                if (this.sessionListener != null) {
                    this.sessionListener.outputReady(this);
                }
                handler = this.ensureHandler();
                handler.outputReady(this);
            }
        }
    }

    @Override
    Timeout getTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    void onTimeout(Timeout timeout) throws IOException {
        IOEventHandler handler = this.ensureHandler();
        handler.timeout(this, timeout);
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null && tlsSession.isOutboundDone() && !tlsSession.isInboundDone()) {
            tlsSession.close(CloseMode.IMMEDIATE);
        }
    }

    @Override
    void onException(Exception cause) {
        IOEventHandler handler = this.ensureHandler();
        if (this.sessionListener != null) {
            this.sessionListener.exception(this, cause);
        }
        handler.exception(this, cause);
    }

    void disconnected() {
        if (this.sessionListener != null) {
            this.sessionListener.disconnected(this);
        }
        IOEventHandler handler = this.ensureHandler();
        handler.disconnected(this);
    }

    @Override
    public void startTls(SSLContext sslContext, NamedEndpoint endpoint, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        if (!this.tlsSessionRef.compareAndSet(null, new SSLIOSession(endpoint != null ? endpoint : this.initialEndpoint, this.ioSession, this.initialEndpoint != null ? SSLMode.CLIENT : SSLMode.SERVER, sslContext, sslBufferMode, initializer, verifier, new Callback<SSLIOSession>(){

            @Override
            public void execute(SSLIOSession sslSession) {
                if (InternalDataChannel.this.connected.compareAndSet(false, true)) {
                    IOEventHandler handler = InternalDataChannel.this.ensureHandler();
                    try {
                        if (InternalDataChannel.this.sessionListener != null) {
                            InternalDataChannel.this.sessionListener.connected(InternalDataChannel.this);
                        }
                        handler.connected(InternalDataChannel.this);
                    }
                    catch (Exception ex) {
                        if (InternalDataChannel.this.sessionListener != null) {
                            InternalDataChannel.this.sessionListener.exception(InternalDataChannel.this, ex);
                        }
                        handler.exception(InternalDataChannel.this, ex);
                    }
                }
            }
        }))) {
            throw new IllegalStateException("TLS already activated");
        }
    }

    @Override
    public TlsDetails getTlsDetails() {
        SSLIOSession sslIoSession = this.tlsSessionRef.get();
        return sslIoSession != null ? sslIoSession.getTlsDetails() : null;
    }

    @Override
    public Lock lock() {
        return this.ioSession.lock();
    }

    private IOSession getSessionImpl() {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        return tlsSession != null ? tlsSession : this.ioSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().close();
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().close(closeMode);
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    @Override
    public int getStatus() {
        return this.getSessionImpl().getStatus();
    }

    @Override
    public boolean isClosed() {
        return this.getSessionImpl().isClosed();
    }

    @Override
    public void enqueue(Command command, Command.Priority priority) {
        this.getSessionImpl().enqueue(command, priority);
    }

    @Override
    public boolean hasCommands() {
        return this.getSessionImpl().hasCommands();
    }

    @Override
    public Command poll() {
        return this.getSessionImpl().poll();
    }

    @Override
    public ByteChannel channel() {
        return this.getSessionImpl().channel();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public int getEventMask() {
        return this.getSessionImpl().getEventMask();
    }

    @Override
    public void setEventMask(int ops) {
        this.getSessionImpl().setEventMask(ops);
    }

    @Override
    public void setEvent(int op) {
        this.getSessionImpl().setEvent(op);
    }

    @Override
    public void clearEvent(int op) {
        this.getSessionImpl().clearEvent(op);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public void updateReadTime() {
        this.ioSession.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.ioSession.updateWriteTime();
    }

    @Override
    public long getLastReadTime() {
        return this.ioSession.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.ioSession.getLastWriteTime();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null) {
            buf.append(tlsSession);
        } else {
            buf.append(this.ioSession);
        }
        IOEventHandler handler = this.getHandler();
        if (handler != null) {
            buf.append(handler);
        }
        return buf.toString();
    }
}

