/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpStreamResetException;
import org.apache.hc.core5.http.nio.AsyncDataProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Contract(threading=ThreadingBehavior.SAFE)
final class ReactiveDataProducer
implements AsyncDataProducer,
Subscriber<ByteBuffer> {
    private static final int BUFFER_WINDOW_SIZE = 5;
    private final AtomicReference<DataStreamChannel> requestChannel = new AtomicReference();
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Publisher<ByteBuffer> publisher;
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final ArrayDeque<ByteBuffer> buffers = new ArrayDeque();
    private final ReentrantLock lock;

    public ReactiveDataProducer(Publisher<ByteBuffer> publisher) {
        this.publisher = (Publisher)Args.notNull(publisher, (String)"publisher");
        this.lock = new ReentrantLock();
    }

    void setChannel(DataStreamChannel channel) {
        this.requestChannel.set(channel);
    }

    public void onSubscribe(Subscription subscription) {
        if (this.subscription.getAndSet(subscription) != null) {
            throw new IllegalStateException("Already subscribed");
        }
        subscription.request(5L);
    }

    public void onNext(ByteBuffer byteBuffer) {
        byte[] copy = new byte[byteBuffer.remaining()];
        byteBuffer.get(copy);
        this.lock.lock();
        try {
            this.buffers.add(ByteBuffer.wrap(copy));
        }
        finally {
            this.lock.unlock();
        }
        this.signalReadiness();
    }

    public void onError(Throwable throwable) {
        this.subscription.set(null);
        this.exception.set(throwable);
        this.signalReadiness();
    }

    public void onComplete() {
        this.subscription.set(null);
        this.complete.set(true);
        this.signalReadiness();
    }

    private void signalReadiness() {
        DataStreamChannel channel = this.requestChannel.get();
        if (channel == null) {
            throw new IllegalStateException("Output channel is not set");
        }
        channel.requestOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        if (this.exception.get() != null || this.complete.get()) {
            return 1;
        }
        this.lock.lock();
        try {
            int sum = 0;
            for (ByteBuffer buffer : this.buffers) {
                sum += buffer.remaining();
            }
            int n = sum;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(DataStreamChannel channel) throws IOException {
        block12: {
            if (this.requestChannel.get() == null) {
                this.requestChannel.set(channel);
                this.publisher.subscribe((Subscriber)this);
            }
            Throwable t = this.exception.get();
            Subscription s = this.subscription.get();
            int buffersToReplenish = 0;
            try {
                this.lock.lock();
                try {
                    if (t != null) {
                        throw new HttpStreamResetException(t.getMessage(), t);
                    }
                    if (this.complete.get() && this.buffers.isEmpty()) {
                        channel.endStream();
                        break block12;
                    }
                    while (!this.buffers.isEmpty()) {
                        ByteBuffer nextBuffer = this.buffers.remove();
                        channel.write(nextBuffer);
                        if (nextBuffer.remaining() > 0) {
                            this.buffers.push(nextBuffer);
                            break;
                        }
                        if (s == null) continue;
                        ++buffersToReplenish;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            finally {
                if (s != null && buffersToReplenish > 0) {
                    s.request((long)buffersToReplenish);
                }
            }
        }
    }

    public void releaseResources() {
        Subscription s = this.subscription.getAndSet(null);
        if (s != null) {
            s.cancel();
        }
    }
}

