/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncServer;
import org.apache.hc.core5.testing.nio.InternalServerHttp1EventHandlerFactory;
import org.apache.hc.core5.util.Asserts;

public class Http1TestServer
extends AsyncServer {
    private final List<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>> routeEntries = new ArrayList<RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>>();
    private final SSLContext sslContext;
    private final SSLSessionInitializer sslSessionInitializer;
    private final SSLSessionVerifier sslSessionVerifier;

    public Http1TestServer(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
    }

    public Http1TestServer() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Asserts.check((this.getStatus() == IOReactorStatus.INACTIVE ? 1 : 0) != 0, (String)"Server has already been started");
        this.routeEntries.add((RequestRouter.Entry<Supplier<AsyncServerExchangeHandler>>)new RequestRouter.Entry(uriPattern, supplier));
    }

    public <T> void register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, (Supplier<AsyncServerExchangeHandler>)((Supplier)() -> new BasicServerExchangeHandler(requestHandler)));
    }

    public InetSocketAddress start(IOEventHandlerFactory handlerFactory) throws Exception {
        this.execute(handlerFactory);
        Future<ListenerEndpoint> future = this.listen(new InetSocketAddress(0));
        ListenerEndpoint listener = future.get();
        return (InetSocketAddress)listener.getAddress();
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, Decorator<AsyncServerExchangeHandler> exchangeHandlerDecorator, Http1Config http1Config) throws Exception {
        return this.start(new InternalServerHttp1EventHandlerFactory(httpProcessor != null ? httpProcessor : HttpProcessors.server(), (HandlerFactory<AsyncServerExchangeHandler>)new DefaultAsyncResponseExchangeHandlerFactory((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null), exchangeHandlerDecorator != null ? exchangeHandlerDecorator : BasicAsyncServerExpectationDecorator::new), http1Config, CharCodingConfig.DEFAULT, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
    }

    public InetSocketAddress start(HttpProcessor httpProcessor, Http1Config http1Config) throws Exception {
        return this.start(httpProcessor, null, http1Config);
    }

    public InetSocketAddress start() throws Exception {
        return this.start(null, null, Http1Config.DEFAULT);
    }
}

