/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationFuture;
import org.apache.hc.client5.http.cache.HttpCacheEntrySerializer;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.impl.cache.AbstractBinaryAsyncCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.HttpByteArrayCacheEntrySerializer;
import org.apache.hc.client5.http.impl.cache.memcached.KeyHashingScheme;
import org.apache.hc.client5.http.impl.cache.memcached.SHA256KeyHashingScheme;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.Args;

public class MemcachedHttpAsyncCacheStorage
extends AbstractBinaryAsyncCacheStorage<CASValue<Object>> {
    private final MemcachedClient client;
    private final KeyHashingScheme keyHashingScheme;

    public MemcachedHttpAsyncCacheStorage(InetSocketAddress address) throws IOException {
        this(new MemcachedClient(new InetSocketAddress[]{address}));
    }

    public MemcachedHttpAsyncCacheStorage(MemcachedClient cache) {
        this(cache, CacheConfig.DEFAULT, HttpByteArrayCacheEntrySerializer.INSTANCE, SHA256KeyHashingScheme.INSTANCE);
    }

    public MemcachedHttpAsyncCacheStorage(MemcachedClient client, CacheConfig config, HttpCacheEntrySerializer<byte[]> serializer, KeyHashingScheme keyHashingScheme) {
        super((config != null ? config : CacheConfig.DEFAULT).getMaxUpdateRetries(), serializer != null ? serializer : HttpByteArrayCacheEntrySerializer.INSTANCE);
        this.client = (MemcachedClient)Args.notNull((Object)client, (String)"Memcached client");
        this.keyHashingScheme = keyHashingScheme;
    }

    @Override
    protected String digestToStorageKey(String key) {
        return this.keyHashingScheme.hash(key);
    }

    private byte[] castAsByteArray(Object storageObject) throws ResourceIOException {
        if (storageObject == null) {
            return null;
        }
        if (storageObject instanceof byte[]) {
            return (byte[])storageObject;
        }
        throw new ResourceIOException("Unexpected cache content: " + storageObject.getClass());
    }

    @Override
    protected byte[] getStorageObject(CASValue<Object> casValue) throws ResourceIOException {
        return this.castAsByteArray(casValue.getValue());
    }

    private <T> Cancellable operation(OperationFuture<T> operationFuture, FutureCallback<T> callback) {
        operationFuture.addListener(future -> {
            try {
                callback.completed(operationFuture.get());
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof Exception) {
                    callback.failed((Exception)ex.getCause());
                }
                callback.failed((Exception)ex);
            }
        });
        return Operations.cancellable(operationFuture);
    }

    @Override
    protected Cancellable store(String storageKey, byte[] storageObject, FutureCallback<Boolean> callback) {
        return this.operation(this.client.set(storageKey, 0, (Object)storageObject), callback);
    }

    @Override
    protected Cancellable restore(String storageKey, FutureCallback<byte[]> callback) {
        GetFuture getFuture = this.client.asyncGet(storageKey);
        getFuture.addListener(future -> {
            try {
                callback.completed((Object)this.castAsByteArray(getFuture.get()));
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof Exception) {
                    callback.failed((Exception)ex.getCause());
                }
                callback.failed((Exception)ex);
            }
        });
        return Operations.cancellable((Future)getFuture);
    }

    @Override
    protected Cancellable getForUpdateCAS(String storageKey, FutureCallback<CASValue<Object>> callback) {
        return this.operation(this.client.asyncGets(storageKey), callback);
    }

    @Override
    protected Cancellable updateCAS(String storageKey, CASValue<Object> casValue, byte[] storageObject, final FutureCallback<Boolean> callback) {
        return this.operation(this.client.asyncCAS(storageKey, casValue.getCas(), (Object)storageObject), new FutureCallback<CASResponse>(){

            public void completed(CASResponse result) {
                callback.completed((Object)(result == CASResponse.OK ? 1 : 0));
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
                callback.cancelled();
            }
        });
    }

    @Override
    protected Cancellable delete(String storageKey, FutureCallback<Boolean> callback) {
        return this.operation(this.client.delete(storageKey), callback);
    }

    @Override
    protected Cancellable bulkRestore(Collection<String> storageKeys, FutureCallback<Map<String, byte[]>> callback) {
        BulkFuture future = this.client.asyncGetBulk(storageKeys);
        future.addListener(future1 -> {
            Map storageObjectMap = future1.get();
            HashMap resultMap = new HashMap(storageObjectMap.size());
            for (Map.Entry resultEntry : storageObjectMap.entrySet()) {
                resultMap.put(resultEntry.getKey(), this.castAsByteArray(resultEntry.getValue()));
            }
            callback.completed(resultMap);
        });
        return Operations.cancellable((Future)future);
    }
}

