/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.impl.cache.CacheControl;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Internal
@Contract(threading=ThreadingBehavior.IMMUTABLE)
final class RequestCacheControl
implements CacheControl {
    private final long maxAge;
    private final long maxStale;
    private final long minFresh;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean onlyIfCached;
    private final long staleIfError;
    private final boolean noTransform;

    RequestCacheControl(long maxAge, long maxStale, long minFresh, boolean noCache, boolean noStore, boolean onlyIfCached, long staleIfError, boolean noTransform) {
        this.maxAge = maxAge;
        this.maxStale = maxStale;
        this.minFresh = minFresh;
        this.noCache = noCache;
        this.noStore = noStore;
        this.onlyIfCached = onlyIfCached;
        this.staleIfError = staleIfError;
        this.noTransform = noTransform;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    public long getMaxStale() {
        return this.maxStale;
    }

    public long getMinFresh() {
        return this.minFresh;
    }

    @Override
    public boolean isNoCache() {
        return this.noCache;
    }

    @Override
    public boolean isNoStore() {
        return this.noStore;
    }

    public boolean isOnlyIfCached() {
        return this.onlyIfCached;
    }

    @Override
    public long getStaleIfError() {
        return this.staleIfError;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        if (this.maxAge >= 0L) {
            buf.append("max-age=").append(this.maxAge).append(",");
        }
        if (this.maxStale >= 0L) {
            buf.append("max-stale=").append(this.maxStale).append(",");
        }
        if (this.minFresh >= 0L) {
            buf.append("max-fresh=").append(this.minFresh).append(",");
        }
        if (this.noCache) {
            buf.append("no-cache").append(",");
        }
        if (this.noStore) {
            buf.append("no-store").append(",");
        }
        if (this.onlyIfCached) {
            buf.append("only-if-cached").append(",");
        }
        if (this.staleIfError >= 0L) {
            buf.append("stale-if-error").append(this.staleIfError).append(",");
        }
        if (this.noTransform) {
            buf.append("no-transform").append(",");
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]");
        return buf.toString();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private long maxAge = -1L;
        private long maxStale = -1L;
        private long minFresh = -1L;
        private boolean noCache;
        private boolean noStore;
        private boolean onlyIfCached;
        private long staleIfError = -1L;
        private boolean noTransform;

        Builder() {
        }

        public long getMaxAge() {
            return this.maxAge;
        }

        public Builder setMaxAge(long maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public long getMaxStale() {
            return this.maxStale;
        }

        public Builder setMaxStale(long maxStale) {
            this.maxStale = maxStale;
            return this;
        }

        public long getMinFresh() {
            return this.minFresh;
        }

        public Builder setMinFresh(long minFresh) {
            this.minFresh = minFresh;
            return this;
        }

        public boolean isNoCache() {
            return this.noCache;
        }

        public Builder setNoCache(boolean noCache) {
            this.noCache = noCache;
            return this;
        }

        public boolean isNoStore() {
            return this.noStore;
        }

        public Builder setNoStore(boolean noStore) {
            this.noStore = noStore;
            return this;
        }

        public boolean isOnlyIfCached() {
            return this.onlyIfCached;
        }

        public Builder setOnlyIfCached(boolean onlyIfCached) {
            this.onlyIfCached = onlyIfCached;
            return this;
        }

        public long getStaleIfError() {
            return this.staleIfError;
        }

        public Builder setStaleIfError(long staleIfError) {
            this.staleIfError = staleIfError;
            return this;
        }

        public boolean isNoTransform() {
            return this.noTransform;
        }

        public Builder setNoTransform(boolean noTransform) {
            this.noTransform = noTransform;
            return this;
        }

        public RequestCacheControl build() {
            return new RequestCacheControl(this.maxAge, this.maxStale, this.minFresh, this.noCache, this.noStore, this.onlyIfCached, this.staleIfError, this.noTransform);
        }
    }
}

