/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.List;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.ResponseCacheControl;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.MessageSupport;

class ConditionalRequestBuilder<T extends HttpRequest> {
    private final Factory<T, T> messageCopier;

    ConditionalRequestBuilder(Factory<T, T> messageCopier) {
        this.messageCopier = messageCopier;
    }

    public T buildConditionalRequest(ResponseCacheControl cacheControl, T request, HttpCacheEntry cacheEntry) {
        Header lastModified;
        HttpRequest newRequest = (HttpRequest)this.messageCopier.create(request);
        Header eTag = cacheEntry.getFirstHeader("ETag");
        if (eTag != null) {
            newRequest.setHeader("If-None-Match", (Object)eTag.getValue());
        }
        if ((lastModified = cacheEntry.getFirstHeader("Last-Modified")) != null) {
            newRequest.setHeader("If-Modified-Since", (Object)lastModified.getValue());
        }
        if (cacheControl.isMustRevalidate() || cacheControl.isProxyRevalidate()) {
            newRequest.addHeader("Cache-Control", (Object)"max-age=0");
        }
        return (T)newRequest;
    }

    public T buildConditionalRequestFromVariants(T request, List<String> variants) {
        HttpRequest newRequest = (HttpRequest)this.messageCopier.create(request);
        newRequest.setHeader(MessageSupport.headerOfTokens((String)"If-None-Match", variants));
        return (T)newRequest;
    }

    public T buildUnconditionalRequest(T request) {
        HttpRequest newRequest = (HttpRequest)this.messageCopier.create(request);
        newRequest.addHeader("Cache-Control", (Object)"no-cache");
        newRequest.removeHeaders("If-Range");
        newRequest.removeHeaders("If-Match");
        newRequest.removeHeaders("If-None-Match");
        newRequest.removeHeaders("If-Unmodified-Since");
        newRequest.removeHeaders("If-Modified-Since");
        return (T)newRequest;
    }
}

