/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;

public class CachingExecBase {
    final AtomicLong cacheHits = new AtomicLong();
    final AtomicLong cacheMisses = new AtomicLong();
    final AtomicLong cacheUpdates = new AtomicLong();
    final ResponseCachingPolicy responseCachingPolicy;
    final CacheValidityPolicy validityPolicy;
    final CachedHttpResponseGenerator responseGenerator;
    final CacheableRequestPolicy cacheableRequestPolicy;
    final CachedResponseSuitabilityChecker suitabilityChecker;
    final CacheConfig cacheConfig;

    CachingExecBase(CacheValidityPolicy validityPolicy, ResponseCachingPolicy responseCachingPolicy, CachedHttpResponseGenerator responseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, CacheConfig config) {
        this.responseCachingPolicy = responseCachingPolicy;
        this.validityPolicy = validityPolicy;
        this.responseGenerator = responseGenerator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = suitabilityChecker;
        this.cacheConfig = config != null ? config : CacheConfig.DEFAULT;
    }

    CachingExecBase(CacheConfig config) {
        this.cacheConfig = config != null ? config : CacheConfig.DEFAULT;
        this.validityPolicy = new CacheValidityPolicy(config);
        this.responseGenerator = new CachedHttpResponseGenerator(this.validityPolicy);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker(this.validityPolicy, this.cacheConfig);
        this.responseCachingPolicy = new ResponseCachingPolicy(this.cacheConfig.isSharedCache(), this.cacheConfig.isNeverCacheHTTP10ResponsesWithQuery(), this.cacheConfig.isNeverCacheHTTP11ResponsesWithQuery());
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    SimpleHttpResponse generateCachedResponse(HttpRequest request, HttpCacheEntry entry, Instant now) throws ResourceIOException {
        if (this.shouldSendNotModifiedResponse(request, entry, now)) {
            return this.responseGenerator.generateNotModifiedResponse(entry);
        }
        return this.responseGenerator.generateResponse(request, entry);
    }

    SimpleHttpResponse generateGatewayTimeout() {
        return SimpleHttpResponse.create((int)504, (String)"Gateway Timeout");
    }

    SimpleHttpResponse unvalidatedCacheHit(HttpRequest request, HttpCacheEntry entry) throws IOException {
        return this.responseGenerator.generateResponse(request, entry);
    }

    Instant getCurrentDate() {
        return Instant.now();
    }

    boolean clientRequestsOurOptions(HttpRequest request) {
        if (!Method.OPTIONS.isSame(request.getMethod())) {
            return false;
        }
        if (!"*".equals(request.getRequestUri())) {
            return false;
        }
        Header h = request.getFirstHeader("Max-Forwards");
        return "0".equals(h != null ? h.getValue() : null);
    }

    boolean shouldSendNotModifiedResponse(HttpRequest request, HttpCacheEntry responseEntry, Instant now) {
        return this.suitabilityChecker.isConditional(request) && this.suitabilityChecker.allConditionalsMatch(request, responseEntry, now);
    }

    boolean staleIfErrorAppliesTo(int statusCode) {
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    void storeRequestIfModifiedSinceFor304Response(HttpRequest request, HttpResponse backendResponse) {
        Header h;
        if (backendResponse.getCode() == 304 && (h = request.getFirstHeader("If-Modified-Since")) != null) {
            backendResponse.addHeader("Last-Modified", (Object)h.getValue());
        }
    }

    boolean isResponseTooBig(EntityDetails entityDetails) {
        if (entityDetails == null) {
            return false;
        }
        long contentLength = entityDetails.getContentLength();
        if (contentLength == -1L) {
            return false;
        }
        long maxObjectSize = this.cacheConfig.getMaxObjectSize();
        return contentLength > maxObjectSize;
    }
}

