/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.time.Instant;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheSupport;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.util.TimeValue;

class CachedHttpResponseGenerator {
    private final CacheValidityPolicy validityStrategy;

    CachedHttpResponseGenerator(CacheValidityPolicy validityStrategy) {
        this.validityStrategy = validityStrategy;
    }

    SimpleHttpResponse generateResponse(HttpRequest request, HttpCacheEntry entry) throws ResourceIOException {
        TimeValue age;
        Instant now = Instant.now();
        SimpleHttpResponse response = new SimpleHttpResponse(entry.getStatus());
        response.setHeaders(entry.getHeaders());
        if (this.responseShouldContainEntity(request, entry)) {
            Resource resource = entry.getResource();
            Header h = entry.getFirstHeader("Content-Type");
            ContentType contentType = h != null ? ContentType.parse((CharSequence)h.getValue()) : null;
            byte[] content = resource.get();
            this.generateContentLength((HttpResponse)response, content);
            response.setBody(content, contentType);
        }
        if (TimeValue.isPositive((TimeValue)(age = this.validityStrategy.getCurrentAge(entry, now)))) {
            if (age.compareTo(CacheSupport.MAX_AGE) >= 0) {
                response.setHeader("Age", (Object)Long.toString(CacheSupport.MAX_AGE.toSeconds()));
            } else {
                response.setHeader("Age", (Object)Long.toString(age.toSeconds()));
            }
        }
        return response;
    }

    SimpleHttpResponse generateNotModifiedResponse(HttpCacheEntry entry) {
        Header lastModifiedHeader;
        Header varyHeader;
        Header cacheControlHeader;
        Header expiresHeader;
        Header contentLocationHeader;
        SimpleHttpResponse response = new SimpleHttpResponse(304, "Not Modified");
        Header dateHeader = entry.getFirstHeader("Date");
        if (dateHeader == null) {
            dateHeader = new BasicHeader("Date", (Object)DateUtils.formatStandardDate((Instant)Instant.now()));
        }
        response.addHeader(dateHeader);
        Header etagHeader = entry.getFirstHeader("ETag");
        if (etagHeader != null) {
            response.addHeader(etagHeader);
        }
        if ((contentLocationHeader = entry.getFirstHeader("Content-Location")) != null) {
            response.addHeader(contentLocationHeader);
        }
        if ((expiresHeader = entry.getFirstHeader("Expires")) != null) {
            response.addHeader(expiresHeader);
        }
        if ((cacheControlHeader = entry.getFirstHeader("Cache-Control")) != null) {
            response.addHeader(cacheControlHeader);
        }
        if ((varyHeader = entry.getFirstHeader("Vary")) != null) {
            response.addHeader(varyHeader);
        }
        if (etagHeader == null && (lastModifiedHeader = entry.getFirstHeader("Last-Modified")) != null) {
            response.addHeader(lastModifiedHeader);
        }
        return response;
    }

    private void generateContentLength(HttpResponse response, byte[] body) {
        response.removeHeaders("Transfer-Encoding");
        response.setHeader("Content-Length", (Object)Integer.toString(body.length));
    }

    private boolean responseShouldContainEntity(HttpRequest request, HttpCacheEntry cacheEntry) {
        return Method.GET.isSame(request.getMethod()) && cacheEntry.getResource() != null;
    }
}

