/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheSupport;
import org.apache.hc.client5.http.impl.cache.ResponseCacheControl;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheValidityPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(CacheValidityPolicy.class);
    private final boolean shared;
    private final boolean useHeuristicCaching;
    private final float heuristicCoefficient;
    private final TimeValue heuristicDefaultLifetime;

    CacheValidityPolicy(CacheConfig config) {
        this.shared = config != null ? config.isSharedCache() : CacheConfig.DEFAULT.isSharedCache();
        this.useHeuristicCaching = config != null ? config.isHeuristicCachingEnabled() : CacheConfig.DEFAULT.isHeuristicCachingEnabled();
        this.heuristicCoefficient = config != null ? config.getHeuristicCoefficient() : CacheConfig.DEFAULT.getHeuristicCoefficient();
        this.heuristicDefaultLifetime = config != null ? config.getHeuristicDefaultLifetime() : CacheConfig.DEFAULT.getHeuristicDefaultLifetime();
    }

    CacheValidityPolicy() {
        this(null);
    }

    public TimeValue getCurrentAge(HttpCacheEntry entry, Instant now) {
        return TimeValue.ofSeconds((long)(this.getCorrectedInitialAge(entry).toSeconds() + this.getResidentTime(entry, now).toSeconds()));
    }

    public TimeValue getFreshnessLifetime(ResponseCacheControl responseCacheControl, HttpCacheEntry entry) {
        Instant expiry;
        long sharedMaxAge;
        if (this.shared && (sharedMaxAge = responseCacheControl.getSharedMaxAge()) > -1L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using s-maxage directive for freshness lifetime calculation: {} seconds", (Object)sharedMaxAge);
            }
            return TimeValue.ofSeconds((long)sharedMaxAge);
        }
        long maxAge = responseCacheControl.getMaxAge();
        if (maxAge > -1L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using max-age directive for freshness lifetime calculation: {} seconds", (Object)maxAge);
            }
            return TimeValue.ofSeconds((long)maxAge);
        }
        Instant dateValue = entry.getInstant();
        if (dateValue != null && (expiry = entry.getExpires()) != null) {
            Duration diff = Duration.between(dateValue, expiry);
            if (diff.isNegative()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Negative freshness lifetime detected. Content is already expired. Returning zero freshness lifetime.");
                }
                return TimeValue.ZERO_MILLISECONDS;
            }
            return TimeValue.ofSeconds((long)diff.getSeconds());
        }
        if (this.useHeuristicCaching) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No explicit expiration time present in the response. Using heuristic freshness lifetime calculation.");
            }
            return this.getHeuristicFreshnessLifetime(entry);
        }
        return TimeValue.ZERO_MILLISECONDS;
    }

    TimeValue getHeuristicFreshnessLifetime(HttpCacheEntry entry) {
        Instant dateValue = entry.getInstant();
        Instant lastModifiedValue = entry.getLastModified();
        if (dateValue != null && lastModifiedValue != null) {
            Duration diff = Duration.between(lastModifiedValue, dateValue);
            if (diff.isNegative()) {
                return TimeValue.ZERO_MILLISECONDS;
            }
            return TimeValue.ofSeconds((long)((long)(this.heuristicCoefficient * (float)diff.getSeconds())));
        }
        return this.heuristicDefaultLifetime;
    }

    TimeValue getApparentAge(HttpCacheEntry entry) {
        Instant dateValue = entry.getInstant();
        if (dateValue == null) {
            return CacheSupport.MAX_AGE;
        }
        Duration diff = Duration.between(dateValue, entry.getResponseInstant());
        if (diff.isNegative()) {
            return TimeValue.ZERO_MILLISECONDS;
        }
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }

    long getAgeValue(HttpCacheEntry entry) {
        Header age = entry.getFirstHeader("Age");
        if (age != null) {
            AtomicReference firstToken = new AtomicReference();
            MessageSupport.parseTokens((Header)age, token -> firstToken.compareAndSet(null, token));
            long delta = CacheSupport.deltaSeconds((String)firstToken.get());
            if (delta == -1L && LOG.isDebugEnabled()) {
                LOG.debug("Malformed Age value: {}", (Object)age);
            }
            return delta > 0L ? delta : 0L;
        }
        return 0L;
    }

    TimeValue getCorrectedAgeValue(HttpCacheEntry entry) {
        long ageValue = this.getAgeValue(entry);
        long responseDelay = this.getResponseDelay(entry).toSeconds();
        return TimeValue.ofSeconds((long)(ageValue + responseDelay));
    }

    TimeValue getResponseDelay(HttpCacheEntry entry) {
        Duration diff = Duration.between(entry.getRequestInstant(), entry.getResponseInstant());
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }

    TimeValue getCorrectedInitialAge(HttpCacheEntry entry) {
        long apparentAge = this.getApparentAge(entry).toSeconds();
        long correctedReceivedAge = this.getCorrectedAgeValue(entry).toSeconds();
        return TimeValue.ofSeconds((long)Math.max(apparentAge, correctedReceivedAge));
    }

    TimeValue getResidentTime(HttpCacheEntry entry, Instant now) {
        Duration diff = Duration.between(entry.getResponseInstant(), now);
        return TimeValue.ofSeconds((long)diff.getSeconds());
    }
}

