/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

class BasicIdGenerator {
    private final String hostname;
    private final SecureRandom rnd;
    private long count;
    private final ReentrantLock lock;

    public BasicIdGenerator() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            hostname = "localhost";
        }
        this.hostname = hostname;
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
        this.rnd.setSeed(System.currentTimeMillis());
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(StringBuilder buffer) {
        this.lock.lock();
        try {
            ++this.count;
            int rndnum = this.rnd.nextInt();
            buffer.append(System.currentTimeMillis());
            buffer.append('.');
            try (Formatter formatter = new Formatter(buffer, Locale.ROOT);){
                formatter.format("%1$016x-%2$08x", this.count, rndnum);
            }
            buffer.append('.');
            buffer.append(this.hostname);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String generate() {
        StringBuilder buffer = new StringBuilder();
        this.generate(buffer);
        return buffer.toString();
    }
}

