/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.hc.client5.http.cache.HttpCacheCASOperation;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheEntryFactory;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.HttpCacheUpdateException;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.BasicHttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheHit;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.CacheMatch;
import org.apache.hc.client5.http.impl.cache.CacheSupport;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicHttpCache
implements HttpCache {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpCache.class);
    private final ResourceFactory resourceFactory;
    private final HttpCacheEntryFactory cacheEntryFactory;
    private final CacheKeyGenerator cacheKeyGenerator;
    private final HttpCacheStorage storage;

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheEntryFactory cacheEntryFactory, HttpCacheStorage storage, CacheKeyGenerator cacheKeyGenerator) {
        this.resourceFactory = resourceFactory;
        this.cacheEntryFactory = cacheEntryFactory;
        this.cacheKeyGenerator = cacheKeyGenerator;
        this.storage = storage;
    }

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage storage, CacheKeyGenerator cacheKeyGenerator) {
        this(resourceFactory, HttpCacheEntryFactory.INSTANCE, storage, cacheKeyGenerator);
    }

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage storage) {
        this(resourceFactory, storage, new CacheKeyGenerator());
    }

    public BasicHttpCache(CacheConfig config) {
        this(new HeapResourceFactory(), new BasicHttpCacheStorage(config));
    }

    public BasicHttpCache() {
        this(CacheConfig.DEFAULT);
    }

    void storeInternal(String cacheKey, HttpCacheEntry entry) {
        block2: {
            try {
                this.storage.putEntry(cacheKey, entry);
            }
            catch (ResourceIOException ex) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("I/O error storing cache entry with key {}", (Object)cacheKey);
            }
        }
    }

    void updateInternal(String cacheKey, HttpCacheCASOperation casOperation) {
        block4: {
            try {
                this.storage.updateEntry(cacheKey, casOperation);
            }
            catch (HttpCacheUpdateException ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Cannot update cache entry with key {}", (Object)cacheKey);
                }
            }
            catch (ResourceIOException ex) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn("I/O error updating cache entry with key {}", (Object)cacheKey);
            }
        }
    }

    HttpCacheEntry getInternal(String cacheKey) {
        try {
            return this.storage.getEntry(cacheKey);
        }
        catch (ResourceIOException ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("I/O error retrieving cache entry with key {}", (Object)cacheKey);
            }
            return null;
        }
    }

    private void removeInternal(String cacheKey) {
        block2: {
            try {
                this.storage.removeEntry(cacheKey);
            }
            catch (ResourceIOException ex) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("I/O error removing cache entry with key {}", (Object)cacheKey);
            }
        }
    }

    @Override
    public CacheMatch match(HttpHost host, HttpRequest request) {
        HttpCacheEntry root;
        String rootKey = this.cacheKeyGenerator.generateKey(host, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get cache root entry: {}", (Object)rootKey);
        }
        if ((root = this.getInternal(rootKey)) == null) {
            return null;
        }
        if (root.hasVariants()) {
            List<String> variantNames = CacheKeyGenerator.variantNames(root);
            String variantKey = this.cacheKeyGenerator.generateVariantKey(request, variantNames);
            if (root.getVariants().contains(variantKey)) {
                HttpCacheEntry entry;
                String cacheKey = variantKey + rootKey;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Get cache variant entry: {}", (Object)cacheKey);
                }
                if ((entry = this.getInternal(cacheKey)) != null) {
                    return new CacheMatch(new CacheHit(rootKey, cacheKey, entry), new CacheHit(rootKey, root));
                }
            }
            return new CacheMatch(null, new CacheHit(rootKey, root));
        }
        return new CacheMatch(new CacheHit(rootKey, root), null);
    }

    @Override
    public List<CacheHit> getVariants(CacheHit hit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get variant cache entries: {}", (Object)hit.rootKey);
        }
        HttpCacheEntry root = hit.entry;
        String rootKey = hit.rootKey;
        if (root != null && root.hasVariants()) {
            ArrayList<CacheHit> variants = new ArrayList<CacheHit>();
            for (String variantKey : root.getVariants()) {
                String variantCacheKey = variantKey + rootKey;
                HttpCacheEntry variant = this.getInternal(variantCacheKey);
                if (variant == null) continue;
                variants.add(new CacheHit(rootKey, variantCacheKey, variant));
            }
            return variants;
        }
        return Collections.emptyList();
    }

    CacheHit store(String rootKey, String variantKey, HttpCacheEntry entry) {
        if (variantKey == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Store entry in cache: {}", (Object)rootKey);
            }
            this.storeInternal(rootKey, entry);
            return new CacheHit(rootKey, entry);
        }
        String variantCacheKey = variantKey + rootKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Store variant entry in cache: {}", (Object)variantCacheKey);
        }
        this.storeInternal(variantCacheKey, entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update root entry: {}", (Object)rootKey);
        }
        this.updateInternal(rootKey, existing -> {
            HashSet<String> variants = existing != null ? new HashSet<String>(existing.getVariants()) : new HashSet();
            variants.add(variantKey);
            return this.cacheEntryFactory.createRoot(entry, variants);
        });
        return new CacheHit(rootKey, variantCacheKey, entry);
    }

    @Override
    public CacheHit store(HttpHost host, HttpRequest request, HttpResponse originResponse, ByteArrayBuffer content, Instant requestSent, Instant responseReceived) {
        Resource resource;
        String rootKey = this.cacheKeyGenerator.generateKey(host, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create cache entry: {}", (Object)rootKey);
        }
        try {
            resource = content != null ? this.resourceFactory.generate(request.getRequestUri(), content.array(), 0, content.length()) : null;
        }
        catch (ResourceIOException ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("I/O error creating cache entry with key {}", (Object)rootKey);
            }
            HttpCacheEntry backup = this.cacheEntryFactory.create(requestSent, responseReceived, host, request, originResponse, content != null ? HeapResourceFactory.INSTANCE.generate(null, content.array(), 0, content.length()) : null);
            return new CacheHit(rootKey, backup);
        }
        HttpCacheEntry entry = this.cacheEntryFactory.create(requestSent, responseReceived, host, request, originResponse, resource);
        String variantKey = this.cacheKeyGenerator.generateVariantKey(request, entry);
        return this.store(rootKey, variantKey, entry);
    }

    @Override
    public CacheHit update(CacheHit stale, HttpHost host, HttpRequest request, HttpResponse originResponse, Instant requestSent, Instant responseReceived) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update cache entry: {}", (Object)stale.getEntryKey());
        }
        HttpCacheEntry updatedEntry = this.cacheEntryFactory.createUpdated(requestSent, responseReceived, host, request, originResponse, stale.entry);
        String variantKey = this.cacheKeyGenerator.generateVariantKey(request, updatedEntry);
        return this.store(stale.rootKey, variantKey, updatedEntry);
    }

    @Override
    public CacheHit storeFromNegotiated(CacheHit negotiated, HttpHost host, HttpRequest request, HttpResponse originResponse, Instant requestSent, Instant responseReceived) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update negotiated cache entry: {}", (Object)negotiated.getEntryKey());
        }
        HttpCacheEntry updatedEntry = this.cacheEntryFactory.createUpdated(requestSent, responseReceived, host, request, originResponse, negotiated.entry);
        this.storeInternal(negotiated.getEntryKey(), updatedEntry);
        String rootKey = this.cacheKeyGenerator.generateKey(host, request);
        HttpCacheEntry copy = this.cacheEntryFactory.copy(updatedEntry);
        String variantKey = this.cacheKeyGenerator.generateVariantKey(request, copy);
        return this.store(rootKey, variantKey, copy);
    }

    private void evictAll(HttpCacheEntry root, String rootKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evicting root cache entry {}", (Object)rootKey);
        }
        this.removeInternal(rootKey);
        if (root.hasVariants()) {
            for (String variantKey : root.getVariants()) {
                String variantEntryKey = variantKey + rootKey;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Evicting variant cache entry {}", (Object)variantEntryKey);
                }
                this.removeInternal(variantEntryKey);
            }
        }
    }

    private void evict(String rootKey) {
        HttpCacheEntry root = this.getInternal(rootKey);
        if (root == null) {
            return;
        }
        this.evictAll(root, rootKey);
    }

    private void evict(String rootKey, HttpResponse response) {
        HttpCacheEntry root = this.getInternal(rootKey);
        if (root == null) {
            return;
        }
        Header existingETag = root.getFirstHeader("ETag");
        Header newETag = response.getFirstHeader("ETag");
        if (existingETag != null && newETag != null && !Objects.equals(existingETag.getValue(), newETag.getValue()) && !HttpCacheEntry.isNewer(root, (MessageHeaders)response)) {
            this.evictAll(root, rootKey);
        }
    }

    @Override
    public void evictInvalidatedEntries(HttpHost host, HttpRequest request, HttpResponse response) {
        int status;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evict cache entries invalidated by exchange: {}; {} -> {}", new Object[]{host, new RequestLine(request), new StatusLine(response)});
        }
        if ((status = response.getCode()) >= 200 && status < 400 && !Method.isSafe((String)request.getMethod())) {
            String rootKey = this.cacheKeyGenerator.generateKey(host, request);
            this.evict(rootKey);
            URI requestUri = CacheKeyGenerator.normalize(CacheKeyGenerator.getRequestUri(host, request));
            if (requestUri != null) {
                URI location;
                URI contentLocation = CacheSupport.getLocationURI(requestUri, (MessageHeaders)response, "Content-Location");
                if (contentLocation != null && CacheSupport.isSameOrigin(requestUri, contentLocation)) {
                    String cacheKey = this.cacheKeyGenerator.generateKey(contentLocation);
                    this.evict(cacheKey, response);
                }
                if ((location = CacheSupport.getLocationURI(requestUri, (MessageHeaders)response, "Location")) != null && CacheSupport.isSameOrigin(requestUri, location)) {
                    String cacheKey = this.cacheKeyGenerator.generateKey(location);
                    this.evict(cacheKey, response);
                }
            }
        }
    }
}

