/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.concurrent.FutureContribution;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.testing.nio.InternalClientH2EventHandlerFactory;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class H2TestClient
extends AsyncRequester {
    private final SSLContext sslContext;
    private final SSLSessionInitializer sslSessionInitializer;
    private final SSLSessionVerifier sslSessionVerifier;
    private final RequestHandlerRegistry<Supplier<AsyncPushConsumer>> registry;

    public H2TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
        this.registry = new RequestHandlerRegistry();
    }

    public H2TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull(supplier, (String)"Supplier");
        this.registry.register(null, uriPattern, supplier);
    }

    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        super.execute(handlerFactory);
    }

    public void start(HttpProcessor httpProcessor, H2Config h2Config) throws IOException {
        this.start(new InternalClientH2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncPushConsumer>)new DefaultAsyncPushConsumerFactory(this.registry), HttpVersionPolicy.FORCE_HTTP_2, h2Config, Http1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
    }

    public void start(HttpProcessor httpProcessor, Http1Config http1Config) throws IOException {
        this.start(new InternalClientH2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncPushConsumer>)new DefaultAsyncPushConsumerFactory(this.registry), HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, http1Config, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
    }

    public void start(H2Config h2Config) throws IOException {
        this.start(H2Processors.client(), h2Config);
    }

    public void start(Http1Config http1Config) throws IOException {
        this.start(H2Processors.client(), http1Config);
    }

    public void start() throws Exception {
        this.start(H2Config.DEFAULT);
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout, FutureCallback<ClientSessionEndpoint> callback) {
        final BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, (FutureCallback<IOSession>)new FutureContribution<IOSession>(future){

            public void completed(IOSession session) {
                future.completed((Object)new ClientSessionEndpoint(session));
            }
        });
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout) {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, Timeout timeout) {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }
}

