/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.ServiceUnavailableRetryStrategy;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ServiceUnavailableRetryExec
implements ExecChainHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull((Object)retryStrategy, (String)"Retry strategy");
        this.retryStrategy = retryStrategy;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        String exchangeId = scope.exchangeId;
        HttpClientContext context = scope.clientContext;
        ClassicHttpRequest currentRequest = request;
        int c = 1;
        while (true) {
            ClassicHttpResponse response = chain.proceed(currentRequest, scope);
            try {
                HttpEntity entity = request.getEntity();
                if (entity != null && !entity.isRepeatable()) {
                    return response;
                }
                if (this.retryStrategy.retryRequest((HttpResponse)response, c, (HttpContext)context)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval((HttpResponse)response, (HttpContext)context);
                    if (nextInterval > 0L) {
                        try {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(exchangeId + ": wait for " + (double)nextInterval / 1000.0 + " seconds");
                            }
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                currentRequest = ClassicRequestCopier.INSTANCE.copy(scope.originalRequest);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

