/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.cache.HttpCacheEntrySerializer;
import org.apache.hc.client5.http.cache.HttpCacheStorageEntry;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class ByteArrayCacheEntrySerializer
implements HttpCacheEntrySerializer<byte[]> {
    private static final List<Pattern> ALLOWED_CLASS_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("^(\\[L)?org\\.apache\\.hc\\.(.*)"), Pattern.compile("^(\\[L)?java\\.util\\.(.*)"), Pattern.compile("^(\\[L)?java\\.lang\\.(.*)$"), Pattern.compile("^\\[B$")));
    public static final ByteArrayCacheEntrySerializer INSTANCE = new ByteArrayCacheEntrySerializer();
    private final List<Pattern> allowedClassPatterns;

    ByteArrayCacheEntrySerializer(Pattern ... allowedClassPatterns) {
        this.allowedClassPatterns = Collections.unmodifiableList(Arrays.asList(allowedClassPatterns));
    }

    public ByteArrayCacheEntrySerializer() {
        this.allowedClassPatterns = ALLOWED_CLASS_PATTERNS;
    }

    @Override
    public byte[] serialize(HttpCacheStorageEntry cacheEntry) throws ResourceIOException {
        if (cacheEntry == null) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(buf);){
            oos.writeObject(cacheEntry);
        }
        catch (IOException ex) {
            throw new ResourceIOException(ex.getMessage(), ex);
        }
        return buf.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpCacheStorageEntry deserialize(byte[] serializedObject) throws ResourceIOException {
        if (serializedObject == null) {
            return null;
        }
        try (RestrictedObjectInputStream ois = new RestrictedObjectInputStream(new ByteArrayInputStream(serializedObject), this.allowedClassPatterns);){
            HttpCacheStorageEntry httpCacheStorageEntry = (HttpCacheStorageEntry)ois.readObject();
            return httpCacheStorageEntry;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new ResourceIOException(ex.getMessage(), ex);
        }
    }

    private static class RestrictedObjectInputStream
    extends ObjectInputStream {
        private final List<Pattern> allowedClassPatterns;

        private RestrictedObjectInputStream(InputStream in, List<Pattern> patterns) throws IOException {
            super(in);
            this.allowedClassPatterns = patterns;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.isProhibited(desc)) {
                throw new ResourceIOException(String.format("Class %s is not allowed for deserialization", desc.getName()));
            }
            return super.resolveClass(desc);
        }

        private boolean isProhibited(ObjectStreamClass desc) {
            if (this.allowedClassPatterns != null) {
                for (Pattern pattern : this.allowedClassPatterns) {
                    if (!pattern.matcher(desc.getName()).matches()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

