/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import javax.net.ssl.SSLContext;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiator;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.testing.nio.LoggingH2StreamListener;
import org.apache.hc.core5.testing.nio.LoggingHttp1StreamListener;
import org.apache.hc.core5.util.Args;

class InternalServerH2EventHandlerFactory
implements IOEventHandlerFactory {
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final H2Config h2Config;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final SSLContext sslContext;

    public InternalServerH2EventHandlerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, HttpVersionPolicy versionPolicy, H2Config h2Config, Http1Config http1Config, CharCodingConfig charCodingConfig, SSLContext sslContext) {
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.exchangeHandlerFactory = (HandlerFactory)Args.notNull(exchangeHandlerFactory, (String)"Exchange handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.h2Config = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.sslContext = sslContext;
    }

    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        if (this.sslContext != null) {
            ioSession.startTls(this.sslContext, null, null, null, null, null);
        }
        ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), this.exchangeHandlerFactory, this.http1Config, this.charCodingConfig, (Http1StreamListener)LoggingHttp1StreamListener.INSTANCE_SERVER);
        ServerH2StreamMultiplexerFactory http2StreamHandlerFactory = new ServerH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.server(), this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, (H2StreamListener)LoggingH2StreamListener.INSTANCE);
        return new ServerHttpProtocolNegotiator(ioSession, http1StreamHandlerFactory, http2StreamHandlerFactory, this.versionPolicy);
    }
}

