/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingIOSessionListener
implements IOSessionListener {
    public static final LoggingIOSessionListener INSTANCE = new LoggingIOSessionListener();
    private final Logger connLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.connection");

    private LoggingIOSessionListener() {
    }

    public void tlsStarted(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " TLS session started");
        }
    }

    public void tlsInbound(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " TLS inbound");
        }
    }

    public void tlsOutbound(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " TLS outbound");
        }
    }

    public void connected(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " connected");
        }
    }

    public void inputReady(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " input ready");
        }
    }

    public void outputReady(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " output ready");
        }
    }

    public void timeout(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " timeout");
        }
    }

    public void exception(IOSession session, Exception ex) {
        if (ex instanceof ConnectionClosedException) {
            return;
        }
        this.connLog.error(session + " " + ex.getMessage(), (Throwable)ex);
    }

    public void disconnected(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(session + " disconnected");
        }
    }
}

