/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http2.frame.FramePrinter;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.testing.classic.LoggingSupport;
import org.apache.hc.core5.testing.nio.LogAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingH2StreamListener
implements H2StreamListener {
    public static final LoggingH2StreamListener INSTANCE = new LoggingH2StreamListener();
    private final Logger headerLog;
    private final Logger frameLog;
    private final Logger framePayloadLog;
    private final Logger flowCtrlLog;
    private final FramePrinter framePrinter = new FramePrinter();

    private LoggingH2StreamListener() {
        this.headerLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.headers");
        this.frameLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http2.frame");
        this.framePayloadLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http2.frame.payload");
        this.flowCtrlLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http2.flow");
    }

    private void logFrameInfo(String prefix, RawFrame frame) {
        try {
            LogAppendable logAppendable = new LogAppendable(this.frameLog, prefix);
            this.framePrinter.printFrameInfo(frame, (Appendable)logAppendable);
            logAppendable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void logFramePayload(String prefix, RawFrame frame) {
        try {
            LogAppendable logAppendable = new LogAppendable(this.framePayloadLog, prefix);
            this.framePrinter.printPayload(frame, (Appendable)logAppendable);
            logAppendable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void logFlowControl(String prefix, int streamId, int delta, int actualSize) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix).append(" stream ").append(streamId).append(" flow control ").append(delta).append(" -> ").append(actualSize);
        this.flowCtrlLog.debug(buffer.toString());
    }

    public void onHeaderInput(HttpConnection connection, int streamId, List<? extends Header> headers) {
        if (this.headerLog.isDebugEnabled()) {
            String prefix = LoggingSupport.getId(connection) + " << ";
            for (int i = 0; i < headers.size(); ++i) {
                this.headerLog.debug(prefix + headers.get(i));
            }
        }
    }

    public void onHeaderOutput(HttpConnection connection, int streamId, List<? extends Header> headers) {
        if (this.headerLog.isDebugEnabled()) {
            String prefix = LoggingSupport.getId(connection) + " >> ";
            for (int i = 0; i < headers.size(); ++i) {
                this.headerLog.debug(prefix + headers.get(i));
            }
        }
    }

    public void onFrameInput(HttpConnection connection, int streamId, RawFrame frame) {
        if (this.frameLog.isDebugEnabled()) {
            this.logFrameInfo(LoggingSupport.getId(connection) + " <<", frame);
        }
        if (this.framePayloadLog.isDebugEnabled()) {
            this.logFramePayload(LoggingSupport.getId(connection) + " <<", frame);
        }
    }

    public void onFrameOutput(HttpConnection connection, int streamId, RawFrame frame) {
        if (this.frameLog.isDebugEnabled()) {
            this.logFrameInfo(LoggingSupport.getId(connection) + " >>", frame);
        }
        if (this.framePayloadLog.isDebugEnabled()) {
            this.logFramePayload(LoggingSupport.getId(connection) + " >>", frame);
        }
    }

    public void onInputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
        if (this.flowCtrlLog.isDebugEnabled()) {
            this.logFlowControl(LoggingSupport.getId(connection) + " <<", streamId, delta, actualSize);
        }
    }

    public void onOutputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
        if (this.flowCtrlLog.isDebugEnabled()) {
            this.logFlowControl(LoggingSupport.getId(connection) + " >>", streamId, delta, actualSize);
        }
    }
}

