/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.LaxConnPool;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.pool.StrictConnPool;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class PoolingAsyncClientConnectionManager
implements AsyncClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 25;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    private final ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> pool;
    private final AsyncClientConnectionOperator connectionOperator;
    private final AtomicBoolean closed;
    private volatile TimeValue validateAfterInactivity;
    private static final AtomicLong COUNT = new AtomicLong(0L);

    public PoolingAsyncClientConnectionManager() {
        this((Lookup<TlsStrategy>)RegistryBuilder.create().register("https", (Object)DefaultClientTlsStrategy.getDefault()).build());
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup) {
        this(tlsStrategyLookup, PoolConcurrencyPolicy.STRICT, TimeValue.NEG_ONE_MILLISECONDS);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, TimeValue timeToLive) {
        this(tlsStrategyLookup, poolConcurrencyPolicy, PoolReusePolicy.LIFO, timeToLive);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive) {
        this(tlsStrategyLookup, poolConcurrencyPolicy, poolReusePolicy, timeToLive, null, null);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultAsyncClientConnectionOperator(tlsStrategyLookup, schemePortResolver, dnsResolver), poolConcurrencyPolicy, poolReusePolicy, timeToLive);
    }

    @Internal
    protected PoolingAsyncClientConnectionManager(AsyncClientConnectionOperator connectionOperator, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive) {
        this.connectionOperator = (AsyncClientConnectionOperator)Args.notNull((Object)connectionOperator, (String)"Connection operator");
        switch (poolConcurrencyPolicy != null ? poolConcurrencyPolicy : PoolConcurrencyPolicy.STRICT) {
            case STRICT: {
                this.pool = new StrictConnPool(5, 25, timeToLive, poolReusePolicy, null);
                break;
            }
            case LAX: {
                this.pool = new LaxConnPool(5, timeToLive, poolReusePolicy, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected PoolConcurrencyPolicy value: " + poolConcurrencyPolicy);
            }
        }
        this.closed = new AtomicBoolean(false);
    }

    @Internal
    protected PoolingAsyncClientConnectionManager(ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> pool, AsyncClientConnectionOperator connectionOperator) {
        this.connectionOperator = (AsyncClientConnectionOperator)Args.notNull((Object)connectionOperator, (String)"Connection operator");
        this.pool = (ManagedConnPool)Args.notNull(pool, (String)"Connection pool");
        this.closed = new AtomicBoolean(false);
    }

    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Shutdown connection pool " + closeMode);
            }
            this.pool.close(closeMode);
            this.log.debug("Connection pool shut down");
        }
    }

    private InternalConnectionEndpoint cast(AsyncConnectionEndpoint endpoint) {
        if (endpoint instanceof InternalConnectionEndpoint) {
            return (InternalConnectionEndpoint)endpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + endpoint.getClass());
    }

    @Override
    public Future<AsyncConnectionEndpoint> lease(final String id, final HttpRoute route, final Object state, Timeout requestTimeout, FutureCallback<AsyncConnectionEndpoint> callback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(id + ": endpoint lease request (" + requestTimeout + ") " + ConnPoolSupport.formatStats(route, state, this.pool));
        }
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        Future leaseFuture = this.pool.lease((Object)route, state, requestTimeout, (FutureCallback)new FutureCallback<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(){

            void leaseCompleted(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
                ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
                if (connection != null) {
                    connection.activate();
                }
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(id + ": endpoint leased " + ConnPoolSupport.formatStats(route, state, (ConnPoolControl<HttpRoute>)PoolingAsyncClientConnectionManager.this.pool));
                }
                InternalConnectionEndpoint endpoint = new InternalConnectionEndpoint(poolEntry);
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(id + ": acquired " + ConnPoolSupport.getId(endpoint));
                }
                resultFuture.completed((Object)endpoint);
            }

            public void completed(final PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
                final ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
                TimeValue timeValue = PoolingAsyncClientConnectionManager.this.validateAfterInactivity;
                if (TimeValue.isPositive((TimeValue)timeValue) && connection != null && poolEntry.getUpdated() + timeValue.toMillis() <= System.currentTimeMillis()) {
                    ProtocolVersion protocolVersion = connection.getProtocolVersion();
                    if (HttpVersion.HTTP_2_0.greaterEquals(protocolVersion)) {
                        connection.submitCommand((Command)new PingCommand((AsyncPingHandler)new BasicPingHandler((Callback)new Callback<Boolean>(){

                            public void execute(Boolean result) {
                                if (result == Boolean.FALSE) {
                                    if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                                        PoolingAsyncClientConnectionManager.this.log.debug(id + ": connection " + ConnPoolSupport.getId(connection) + " is stale");
                                    }
                                    poolEntry.discardConnection(CloseMode.IMMEDIATE);
                                }
                                this.leaseCompleted((PoolEntry<HttpRoute, ManagedAsyncClientConnection>)poolEntry);
                            }
                        })), Command.Priority.IMMEDIATE);
                    } else {
                        if (!connection.isOpen()) {
                            if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                                PoolingAsyncClientConnectionManager.this.log.debug(id + ": connection " + ConnPoolSupport.getId(connection) + " is closed");
                            }
                            poolEntry.discardConnection(CloseMode.IMMEDIATE);
                        }
                        this.leaseCompleted(poolEntry);
                    }
                } else {
                    this.leaseCompleted(poolEntry);
                }
            }

            public void failed(Exception ex) {
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(id + ": endpoint lease failed");
                }
                resultFuture.failed(ex);
            }

            public void cancelled() {
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(id + ": endpoint lease cancelled");
                }
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(leaseFuture);
        return resultFuture;
    }

    @Override
    public void release(AsyncConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
        ManagedAsyncClientConnection connection;
        Args.notNull((Object)endpoint, (String)"Managed endpoint");
        Args.notNull((Object)keepAlive, (String)"Keep-alive time");
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> entry = this.cast(endpoint).detach();
        if (entry == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": releasing endpoint");
        }
        boolean reusable = (connection = (ManagedAsyncClientConnection)entry.getConnection()) != null && connection.isOpen();
        try {
            if (reusable) {
                entry.updateState(state);
                entry.updateExpiry(keepAlive);
                connection.passivate();
                if (this.log.isDebugEnabled()) {
                    String s = TimeValue.isPositive((TimeValue)keepAlive) ? "for " + keepAlive : "indefinitely";
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": connection " + ConnPoolSupport.getId(connection) + " can be kept alive " + s);
                }
            }
        }
        catch (RuntimeException ex) {
            reusable = false;
            throw ex;
        }
        finally {
            this.pool.release(entry, reusable);
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": connection released " + ConnPoolSupport.formatStats((HttpRoute)entry.getRoute(), entry.getState(), this.pool));
            }
        }
    }

    @Override
    public Future<AsyncConnectionEndpoint> connect(final AsyncConnectionEndpoint endpoint, ConnectionInitiator connectionInitiator, Timeout connectTimeout, Object attachment, HttpContext context, FutureCallback<AsyncConnectionEndpoint> callback) {
        Args.notNull((Object)endpoint, (String)"Endpoint");
        Args.notNull((Object)connectionInitiator, (String)"Connection initiator");
        Args.notNull((Object)connectTimeout, (String)"Timeout");
        final InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        if (internalEndpoint.isConnected()) {
            resultFuture.completed((Object)endpoint);
            return resultFuture;
        }
        final PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = internalEndpoint.getPoolEntry();
        HttpRoute route = (HttpRoute)poolEntry.getRoute();
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": connecting endpoint to " + host + " (" + connectTimeout + ")");
        }
        Future<ManagedAsyncClientConnection> connectFuture = this.connectionOperator.connect(connectionInitiator, host, localAddress, connectTimeout, attachment, new FutureCallback<ManagedAsyncClientConnection>(){

            public void completed(ManagedAsyncClientConnection connection) {
                try {
                    if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                        PoolingAsyncClientConnectionManager.this.log.debug(ConnPoolSupport.getId(endpoint) + ": connected " + ConnPoolSupport.getId(connection));
                    }
                    poolEntry.assignConnection((ModalCloseable)connection);
                    resultFuture.completed((Object)internalEndpoint);
                }
                catch (RuntimeException ex) {
                    resultFuture.failed((Exception)ex);
                }
            }

            public void failed(Exception ex) {
                resultFuture.failed(ex);
            }

            public void cancelled() {
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(connectFuture);
        return resultFuture;
    }

    @Override
    public void upgrade(AsyncConnectionEndpoint endpoint, Object attachment, HttpContext context) {
        Args.notNull((Object)endpoint, (String)"Managed endpoint");
        InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = internalEndpoint.getValidatedPoolEntry();
        HttpRoute route = (HttpRoute)poolEntry.getRoute();
        ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
        this.connectionOperator.upgrade((ManagedAsyncClientConnection)poolEntry.getConnection(), route.getTargetHost(), attachment);
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(internalEndpoint) + ": upgraded " + ConnPoolSupport.getId(connection));
        }
    }

    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    public void setMaxPerRoute(HttpRoute route, int max) {
        this.pool.setMaxPerRoute((Object)route, max);
    }

    public int getMaxPerRoute(HttpRoute route) {
        return this.pool.getMaxPerRoute((Object)route);
    }

    public void closeIdle(TimeValue idletime) {
        this.pool.closeIdle(idletime);
    }

    public void closeExpired() {
        this.pool.closeExpired();
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats((Object)route);
    }

    public TimeValue getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(TimeValue validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    class InternalConnectionEndpoint
    extends AsyncConnectionEndpoint
    implements Identifiable {
        private final AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>> poolEntryRef;
        private final String id;

        InternalConnectionEndpoint(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
            this.poolEntryRef = new AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(poolEntry);
            this.id = String.format("ep-%08X", COUNT.getAndIncrement());
        }

        public String getId() {
            return this.id;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> getPoolEntry() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            return poolEntry;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> getValidatedPoolEntry() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.getPoolEntry();
            ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
            Asserts.check((connection != null && connection.isOpen() ? 1 : 0) != 0, (String)"Endpoint is not connected");
            return poolEntry;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> detach() {
            return this.poolEntryRef.getAndSet(null);
        }

        public void close(CloseMode closeMode) {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry != null) {
                if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                    PoolingAsyncClientConnectionManager.this.log.debug(this.id + ": close " + closeMode);
                }
                poolEntry.discardConnection(closeMode);
            }
        }

        @Override
        public boolean isConnected() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                return false;
            }
            ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)poolEntry.getConnection();
            if (connection == null) {
                return false;
            }
            if (!connection.isOpen()) {
                poolEntry.discardConnection(CloseMode.IMMEDIATE);
                return false;
            }
            return true;
        }

        @Override
        public void setSocketTimeout(Timeout timeout) {
            ((ManagedAsyncClientConnection)this.getValidatedPoolEntry().getConnection()).setSocketTimeout(timeout);
        }

        @Override
        public void execute(String exchangeId, AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context) {
            ManagedAsyncClientConnection connection = (ManagedAsyncClientConnection)this.getValidatedPoolEntry().getConnection();
            if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingAsyncClientConnectionManager.this.log.debug(this.id + ": executing exchange " + exchangeId + " over " + ConnPoolSupport.getId(connection));
            }
            connection.submitCommand((Command)new RequestExecutionCommand(exchangeHandler, pushHandlerFactory, context), Command.Priority.NORMAL);
        }
    }
}

