/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.Wire;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class LoggingIOSession
implements ProtocolIOSession {
    private final Logger log;
    private final Wire wireLog;
    private final String id;
    private final ProtocolIOSession session;
    private final ByteChannel channel;

    public LoggingIOSession(ProtocolIOSession session, String id, Logger log, Logger wireLog) {
        this.session = session;
        this.id = id;
        this.log = log;
        this.wireLog = new Wire(wireLog, this.id);
        this.channel = new LoggingByteChannel();
    }

    public LoggingIOSession(ProtocolIOSession session, String id, Logger log) {
        this(session, id, log, null);
    }

    public String getId() {
        return this.session.getId();
    }

    public Lock getLock() {
        return this.session.getLock();
    }

    public boolean hasCommands() {
        return this.session.hasCommands();
    }

    public Command poll() {
        return this.session.poll();
    }

    public void enqueue(Command command, Command.Priority priority) {
        this.session.enqueue(command, priority);
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int ops) {
        StringBuilder buffer = new StringBuilder(6);
        buffer.append('[');
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void setEventMask(int ops) {
        this.session.setEventMask(ops);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event mask set " + LoggingIOSession.formatOps(ops));
        }
    }

    public void setEvent(int op) {
        this.session.setEvent(op);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event set " + LoggingIOSession.formatOps(op));
        }
    }

    public void clearEvent(int op) {
        this.session.clearEvent(op);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event cleared " + LoggingIOSession.formatOps(op));
        }
    }

    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Close");
        }
        this.session.close();
    }

    public int getStatus() {
        return this.session.getStatus();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void close(CloseMode closeMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Close " + closeMode);
        }
        this.session.close(closeMode);
    }

    public Timeout getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    public void setSocketTimeout(Timeout timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Set timeout " + timeout);
        }
        this.session.setSocketTimeout(timeout);
    }

    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    public void updateReadTime() {
        this.session.updateReadTime();
    }

    public void updateWriteTime() {
        this.session.updateWriteTime();
    }

    public long getLastEventTime() {
        return this.session.getLastEventTime();
    }

    public IOEventHandler getHandler() {
        return this.session.getHandler();
    }

    public void upgrade(IOEventHandler handler) {
        this.session.upgrade(handler);
    }

    public void startTls(SSLContext sslContext, NamedEndpoint endpoint, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Timeout handshakeTimeout) throws UnsupportedOperationException {
        this.session.startTls(sslContext, endpoint, sslBufferMode, initializer, verifier, handshakeTimeout);
    }

    public TlsDetails getTlsDetails() {
        return this.session.getTlsDetails();
    }

    public NamedEndpoint getInitialEndpoint() {
        return this.session.getInitialEndpoint();
    }

    public String toString() {
        return this.id + " " + this.session.toString();
    }

    class LoggingByteChannel
    implements ByteChannel {
        LoggingByteChannel() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int bytesRead = LoggingIOSession.this.session.channel().read(dst);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + bytesRead + " bytes read");
            }
            if (bytesRead > 0 && LoggingIOSession.this.wireLog.isEnabled()) {
                ByteBuffer b = dst.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - bytesRead);
                LoggingIOSession.this.wireLog.input(b);
            }
            return bytesRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int byteWritten = LoggingIOSession.this.session.channel().write(src);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + byteWritten + " bytes written");
            }
            if (byteWritten > 0 && LoggingIOSession.this.wireLog.isEnabled()) {
                ByteBuffer b = src.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - byteWritten);
                LoggingIOSession.this.wireLog.output(b);
            }
            return byteWritten;
        }

        @Override
        public void close() throws IOException {
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": Channel close");
            }
            LoggingIOSession.this.session.channel().close();
        }

        @Override
        public boolean isOpen() {
            return LoggingIOSession.this.session.channel().isOpen();
        }
    }
}

